% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stochastics.R
\name{LDS_rep}
\alias{LDS_rep}
\title{Multiple LDS replicates}
\usage{
LDS_rep(
  theta,
  u = NULL,
  v = NULL,
  years,
  num.reps = 100,
  mu = 0,
  exp.trans = TRUE
)
}
\arguments{
\item{theta}{A list of parameters: A, B, C, D, Q, R, x0, v0}

\item{u}{Input matrix for the state equation (m_u rows, T columns)}

\item{v}{Input matrix for the output equation (m_v rows, T columns)}

\item{years}{The years of the study horizon}

\item{num.reps}{The number of stochastic replicates#'}

\item{mu}{Mean of the log-transformed streamflow process}

\item{exp.trans}{Whether exponential transformation back to the streamflow space is required.
If TRUE, both Y and Q are returned, otherwise only Y.}
}
\value{
Same as \link{one_LDS_rep}, but the data.table consists of multiple replicates.
}
\description{
Generate multiple stochastic time series from an LDS model. This is a convenient wrapper for \link{one_LDS_rep}.
}
\examples{
LDS_rep(theta, t(NPpc), t(NPpc), 1200:2012, num.reps = 10, mu = mean(log(NPannual$Qa)))
}
