% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LDS_reconstruction.R
\name{cvLDS}
\alias{cvLDS}
\title{Cross validate LDS model. This is a wrapper for \link{LDS_reconstruction}}
\usage{
cvLDS(
  Qa,
  u,
  v,
  start.year,
  method = "EM",
  transform = "log",
  num.restarts = 50,
  Z = make_Z(Qa$Qa),
  metric.space = "transformed",
  use.raw = FALSE,
  ub = NULL,
  lb = NULL,
  num.islands = 4,
  pop.per.island = 100,
  niter = 1000,
  tol = 1e-05
)
}
\arguments{
\item{Qa}{Observations: a data.frame of annual streamflow with at least two columns: year and Qa.}

\item{u}{Input matrix for a single-model reconstruction, or a list of input matrices for an ensemble reconstruction.}

\item{v}{Same as u.}

\item{start.year}{Starting year of the climate proxies, i.e, the first year of the paleo period. \code{start.year + nrow(pc) - 1} will determine the last year of the study horizon, which must be greater than or equal to the last year in \code{Qa}.}

\item{method}{By default this is "EM". There are experimental methods but you should not try.}

\item{transform}{Flow transformation, either "log", "boxcox" or "none". Note that if the Box-Cox transform is used, the confidence interval after back-transformation is simply the back-transform of the trained onfidence interval; this is hackish and not entirely accurate.}

\item{num.restarts}{The number of initial conditions to start the EM search; ignored if \code{init} is provided.}

\item{Z}{A list of cross-validation folds. If \code{NULL}, will be created with \code{make_Z()} with default settings. Users are advised to use \code{make_Z()} to create the cross-validation folds beforehand. See \link{make_Z} for details.}

\item{metric.space}{Either "transformed" or "original", the space to calculate the performance metrics.}

\item{use.raw}{Whether performance metrics are calculated on the raw time series. Experimental; don't use.}

\item{ub}{Upper bounds, a vector whose length is the number of parameters}

\item{lb}{Lower bounds}

\item{num.islands}{Number of islands (if method is GA; experimental)}

\item{pop.per.island}{Initial population per island (if method is GA; experimental)}

\item{niter}{Maximum number of iterations, default 1000}

\item{tol}{Tolerance for likelihood convergence, default 1e-5. Note that the log-likelihood is normalized by dividing by the number of observations.}
}
\value{
A list of cross validation results
\itemize{
\item metrics.dist: distribution of performance metrics across all cross-validation runs; a matrix, one column for each metric, with column names.
\item metrics: average performance metrics; a named vector.
\item target: the (transformed) observations used for cross-validation; a data.table with two columns (year, y)
\item Ycv: the predicted streamflow in each cross validation run; a matrix, one column for each cross-validation run
\item Z: the cross-validation
}
}
\description{
Cross validate LDS model. This is a wrapper for \link{LDS_reconstruction}
}
\examples{
# Make a shorter time horizon so that this example runs fast
u <- v <- t(NPpc[601:813])
# We run this example without parallelism.
foreach::registerDoSEQ()
cvLDS(NPannual, u, v, start.year = 1800, num.restarts = 2,
      Z = make_Z(NPannual$Qa, nRuns = 1))
# Please refer to the vignette for the full run with parallel options. It takes a minute or two.
}
