% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{sf_create}
\alias{sf_create}
\title{Create Stageframe for Population Matrix Projection Analysis}
\usage{
sf_create(
  sizes,
  stagenames = NULL,
  sizesb = NULL,
  sizesc = NULL,
  repstatus = NULL,
  obsstatus = NULL,
  propstatus = NULL,
  matstatus = NULL,
  immstatus = NULL,
  minage = NULL,
  maxage = NULL,
  indataset = NULL,
  sizemin = NULL,
  sizebmin = NULL,
  sizecmin = NULL,
  sizemax = NULL,
  sizebmax = NULL,
  sizecmax = NULL,
  binhalfwidth = NULL,
  binhalfwidthb = NULL,
  binhalfwidthc = NULL,
  group = NULL,
  comments = NULL,
  roundsize = 5L,
  roundsizeb = 5L,
  roundsizec = 5L,
  ipmbins = 100L,
  ipmbinsb = NA_integer_,
  ipmbinsc = NA_integer_
)
}
\arguments{
\item{sizes}{A numeric vector of the typical or representative size of each
life history stage. If making function-based MPMs, then this may be a
vector composed of the midpoints of each size bin, or simply of sizes
characteristic of the size bins. If denoting the boundary of an automated
size classification group, then should denote the absolute minimum size of
that group, or the absolute size of that group (see \code{Notes}).}

\item{stagenames}{A vector of stage names, in the same order as elements in
sizes. Can also be set to \code{ipm} for automated size classification (see
\code{Notes} section).}

\item{sizesb}{An optional numeric vector for a second size metric for each
life history stage. Only to be used if stages are defined by at least two
size metrics in all cases. Same issues apply as in \code{sizes}.}

\item{sizesc}{An optional numeric vector for a third size metric for each
life history stage. Only to be used if stages are defined by at least three
size metrics in all cases. Same issues apply as in \code{sizes}.}

\item{repstatus}{A vector denoting the binomial reproductive status of each
life history stage. Defaults to \code{1}.}

\item{obsstatus}{A vector denoting the binomial observation status of each
life history stage. Defaults to \code{1}, but may be changed for
unobservable stages.}

\item{propstatus}{A vector denoting whether each life history stage is a 
propagule. Such stages are generally only used in fecundity estimation. 
Defaults to \code{0}.}

\item{matstatus}{A vector denoting whether each stage is mature. Must be
composed of binomial values if given. Defaults to 1 for all stages defined 
in \code{sizes}.}

\item{immstatus}{A vector denoting whether each stage is immature. Must be
composed of binomial values if given. Defaults to the complement of vector
\code{matstatus}.}

\item{minage}{An optional vector denoting the minimum age at which a stage
can occur. Only used in age x stage matrix development. Defaults to
\code{NA}.}

\item{maxage}{An optional vector denoting the maximum age at which a stage
should occur. Only used in age x stage matrix development. Defaults to
\code{NA}.}

\item{indataset}{A vector designating which stages are found within the 
dataset. While \code{\link{rlefko2}()} and \code{\link{rlefko3}()} can use
all stages in the input dataset, \code{\link{flefko3}()} and
\code{\link{flefko2}()} can only handle size-classified stages with
non-overlapping combinations of size and status variables. Stages that do
not actually exist within the dataset should be marked as \code{0} in this
vector.}

\item{sizemin}{A vector giving the absolute minimum values corresponding to
each size in the \code{sizes} vector. Requires associated values for
\code{sizemax} if used. Only required if not using \code{binhalfwidth}.}

\item{sizebmin}{A vector giving the absolute minimum values corresponding to
each size in the \code{sizesb} vector. Requires associated values for
\code{sizebmax} if used. Only required if not using \code{binhalfwidthb}.}

\item{sizecmin}{A vector giving the absolute minimum values corresponding to
each size in the \code{sizesc} vector. Requires associated values for
\code{sizecmax} if used. Only required if not using \code{binhalfwidthc}.}

\item{sizemax}{A vector giving the absolute maximum values corresponding to
each size in the \code{sizes} vector. Requires associated values for
\code{sizemin} if used. Only required if not using \code{binhalfwidth}.}

\item{sizebmax}{A vector giving the absolute maximum values corresponding to
each size in the \code{sizesb} vector. Requires associated values for
\code{sizebmin} if used. Only required if not using \code{binhalfwidthb}.}

\item{sizecmax}{A vector giving the absolute maximum values corresponding to
each size in the \code{sizesc} vector. Requires associated values for
\code{sizecmin} if used. Only required if not using \code{binhalfwidthc}.}

\item{binhalfwidth}{A numeric vector giving the half-width of size bins.
Required if \code{sizemin} and \code{sizemax} are not used. Defaults to
\code{0.5} for all sizes.}

\item{binhalfwidthb}{A numeric vector giving the half-width of size bins
used for the optional second size metric. Required if \code{sizebmin} and
\code{sizebmax} are not used but two or three size classes are used.
Defaults to \code{0.5} for all sizes.}

\item{binhalfwidthc}{A numeric vector giving the half-width of size bins
used for the optional third size metric. Required if \code{sizecmin} and
\code{sizecmax} are not used but three size classes are used. Defaults to
\code{0.5} for all sizes.}

\item{group}{An integer vector providing information on each respective
stage's size classification group. If used, then function-based MPM creation
functions \code{\link{flefko2}()}, \code{\link{flefko3}()}, and
\code{\link{aflefko2}()} will estimate transitions only within these groups
and for allowed cross-group transitions noted within the supplement table.
Defaults to \code{0}.}

\item{comments}{An optional vector of text entries holding useful text
descriptions of all stages.}

\item{roundsize}{This parameter sets the precision of size classification,
and equals the number of digits used in rounding sizes. Defaults to
\code{5}.}

\item{roundsizeb}{This parameter sets the precision of size classification
in the optional second size metric, and equals the number of digits used in
rounding sizes. Defaults to \code{5}.}

\item{roundsizec}{This parameter sets the precision of size classification
in the optional third size metric, and equals the number of digits used in
rounding sizes. Defaults to \code{5}.}

\item{ipmbins}{An integer giving the number of size bins to create using the
primary size classification variable. This number is in addition to any
stages that are not size classified. Defaults to \code{100}, and numbers
greater than this yield a warning about the loss of statistical power and
increasing chance of matrix over-parameterization resulting from increasing
numbers of stages.}

\item{ipmbinsb}{An optional integer giving the number of size bins to create
using the secondary size classification variable. This number is in addition
to any stages that are not size classified, as well as in addition to any
automated size classification using the primary and tertiary size variables.
Defaults to \code{NA}, and must be set to a positive integer for automated
size classification to progress.}

\item{ipmbinsc}{An optional integer giving the number of size bins to create
using the tertiary size classification variable. This number is in addition
to any stages that are not size classified, as well as in addition to any
automated size classification using the primary and secondary size
variables. Defaults to \code{NA}, and must be set to a positive integer for
automated size classification to progress.}
}
\value{
A data frame of class \code{stageframe}, which includes information
on the stage name, size, reproductive status, observation status, propagule 
status, immaturity status, maturity status, presence within the core dataset, 
stage group classification, raw bin half-width, and the minimum, 
center, and maximum of each size bin, as well as its width. If minimum and
maximum ages were specified, then these are also included. Also includes an 
empty string variable that can be used to describe stages meaningfully. This
object can be used as the \code{stageframe} input for \code{\link{flefko3}()} 
\code{\link{flefko2}()}, \code{\link{rlefko3}()}, and \code{\link{rlefko2}()}.

Variables in this data frame include the following:
\item{stage}{The unique names of the stages to be analyzed.}
\item{size}{The typical or representative size at which each stage occurs.}
\item{size_b}{Size at which each stage occurs in terms of a second size
variable, if one exists.}
\item{size_c}{Size at which each stage occurs in terms of a third size
variable, if one exists.}
\item{min_age}{The minimum age at which the stage may occur.}
\item{max_age}{The maximum age at which the stage may occur.}
\item{repstatus}{A binomial variable showing whether each stage is
reproductive.}
\item{obsstatus}{A binomial variable showing whether each stage is
observable.}
\item{propstatus}{A binomial variable showing whether each stage is a
propagule.}
\item{immstatus}{A binomial variable showing whether each stage can occur as
immature.}
\item{matstatus}{A binomial variable showing whether each stage occurs in
maturity.}
\item{indataset}{A binomial variable describing whether each stage occurs in
the input dataset.}
\item{binhalfwidth_raw}{The half-width of the size bin, as input.}
\item{sizebin_min}{The minimum size at which the stage may occur.}
\item{sizebin_max}{The maximum size at which the stage may occur.}
\item{sizebin_center}{The midpoint of the size bin at which the stage may
occur.}
\item{sizebin_width}{The width of the size bin corresponding to the stage.}
\item{binhalfwidthb_raw}{The half-width of the size bin of a second size
variable, as input.}
\item{sizebinb_min}{The minimum size at which the stage may occur.}
\item{sizebinb_max}{The maximum size at which the stage may occur.}
\item{sizebinb_center}{The midpoint of the size bin at which the stage may
occur, in terms of a second size variable.}
\item{sizebinb_width}{The width of the size bin corresponding to the stage,
in terms of a second size variable.}
\item{binhalfwidthc_raw}{The half-width of the size bin of a third size
variable, as input.}
\item{sizebinc_min}{The minimum size at which the stage may occur, in terms
of a third size variable.}
\item{sizebinc_max}{The maximum size at which the stage may occur, in terms
of a third size variable.}
\item{sizebinc_center}{The midpoint of the size bin at which the stage may
occur, in terms of a third size variable.}
\item{sizebinc_width}{The width of the size bin corresponding to the stage,
in terms of a third size variable.}
\item{group}{An integer denoting the size classification group that the
stage falls within.}
\item{comments}{A text field for stage descriptions.}
}
\description{
Function \code{sf_create()} returns a data frame describing each ahistorical
life history stage in the life history model. This data frame can be used as 
input into MPM creation functions including \code{\link{flefko3}()}, 
\code{\link{flefko2}()}, \code{\link{aflefko2}()}, \code{\link{rlefko3}()},
\code{\link{rlefko2}()}, and \code{\link{arlefko2}()}, in which it
determines how each stage is treated during matrix estimation.
}
\section{Notes}{

Vectors used to create a stageframe may not mix \code{NA} values with
non-\code{NA} values.

If an IPM or function-based matrix with automated size classification is
desired, then two stages that occur within the dataset and represent the
lower and upper size limits of the IPM must be marked with \code{ipm} in
the stagenames vector. These stages should have all characteristics other
than size equal, and the size input for whichever size will be classified
automatically must include the minimum in one stage and the maximum in the
other. The actual characteristics of the first stage encountered in the
inputs will be used as the template for the creation of these sizes. Note
that \code{ipm} refers to size classification with the primary size
variable. To automate size classification with the secondary size variable,
use \code{ipmb}, and to automate size classification with the tertiary size
variable, use \code{ipmc}. To nest automated size classifications, use 
\code{ipmab} for the primary and secondary size variables, \code{ipmac} for
the primary and tertiary size variables, \code{ipmbc} for the secondary and
tertiary size variables, and \code{ipmabc} for all three size variables.
The primary size variable can also be set with \code{ipma}.

If two or more groups of stages, each with its own characteristics, are to
be developed for an IPM or function-based MPM, then an even number of stages
with two stages marking the minimum and maximum size of each group should be
marked with the same code as given above, with all other characteristics
equal within each group.

Stage classification groups set with the \code{group} variable create zones
within function-based matrices in which survival transitions are estimated.
These groups should not be set if transitions are possible between all
stages regardless of group. To denote specific transitions as estimable
between stage groups, use the \code{\link{supplemental}()} function.

If importing an IPM rather than building one with \code{lefko3}: Using the
\code{vrm_import} approach to building function-based MPMs with provided
linear model slope coefficients requires careful attention to the
stageframe. Although no hfv data frame needs to be entered in this instance,
stages for which vital rates are to be estimated via linear models
parameterized with coefficients provided via function
\code{\link{vrm_import}()} should be marked as occurring within the dataset.
Stages for which the provided coefficients should not be used should be
marked as not occurring within the dataset.
}

\examples{
# Lathyrus example
data(lathyrus)

sizevector <- c(0, 100, 13, 127, 3730, 3800, 0)
stagevector <- c("Sd", "Sdl", "VSm", "Sm", "VLa", "Flo", "Dorm")
repvector <- c(0, 0, 0, 0, 0, 1, 0)
obsvector <- c(0, 1, 1, 1, 1, 1, 0)
matvector <- c(0, 0, 1, 1, 1, 1, 1)
immvector <- c(1, 1, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 100, 11, 103, 3500, 3800, 0.5)

lathframe <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  immstatus = immvector, indataset = indataset, binhalfwidth = binvec,
  propstatus = propvector)

# Cypripedium example
data(cypdata)

sizevector <- c(0, 0, 0, 0, 0, 0, 1, 2.5, 4.5, 8, 17.5)
stagevector <- c("SD", "P1", "P2", "P3", "SL", "D", "XSm", "Sm", "Md", "Lg",
  "XLg")
repvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
obsvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
matvector <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
immvector <- c(0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 0, 0, 0, 0, 0.5, 0.5, 1, 1, 2.5, 7)

cypframe_raw <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  propstatus = propvector, immstatus = immvector, indataset = indataset,
  binhalfwidth = binvec)

}
