% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datamanag.R
\name{delete_lM}
\alias{delete_lM}
\title{Delete Matrices from lefkoMat or lefkoMatList Object}
\usage{
delete_lM(lM, mat_num = NA, pop = NA, patch = NA, year = NA)
}
\arguments{
\item{lM}{The \code{lefkoMat} or \code{lefkoMatList} object to delete
matrices from.}

\item{mat_num}{Either a single integer corresponding to the matrix to remove
within the \code{labels} element of \code{lM}, or a vector of such integers.}

\item{pop}{The population designation for matrices to remove. Only used if
\code{mat_num} is not given.}

\item{patch}{The patch designation for matrices to remove. Only used if
\code{mat_num} is not given.}

\item{year}{The time \emph{t} designation for matrices to remove. Only used
if \code{mat_num} is not given.}
}
\value{
A \code{lefkoMat} or \code{lefkoMatList} object in which the matrices
specified in \code{lM} have been removed. Note that, if applying to a
\code{lefkoMatList} object, then matrices will be deleted from ALL composite
\code{lefkoMat} objects.
}
\description{
Function \code{delete_lM()} deletes matrices from \code{lefkoMat} and
\code{lefkoMatList} objects.
}
\section{Notes}{

If \code{mat_num} is not provided, then at least one of \code{pop},
\code{patch}, or \code{year} must be provided. If at least two of \code{pop},
\code{patch}, and \code{year} are provided, then function \code{detele_lM()}
will identify matrices to remove as the intersection of provided inputs.
}

\examples{
# These matrices are of 9 populations of the plant species Anthyllis
# vulneraria, and were originally published in Davison et al. (2010) Journal
# of Ecology 98:255-267 (doi: 10.1111/j.1365-2745.2009.01611.x).

sizevector <- c(1, 1, 2, 3) # These sizes are not from the original paper
stagevector <- c("Sdl", "Veg", "SmFlo", "LFlo")
repvector <- c(0, 0, 1, 1)
obsvector <- c(1, 1, 1, 1)
matvector <- c(0, 1, 1, 1)
immvector <- c(1, 0, 0, 0)
propvector <- c(0, 0, 0, 0)
indataset <- c(1, 1, 1, 1)
binvec <- c(0.5, 0.5, 0.5, 0.5)

anthframe <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  immstatus = immvector, indataset = indataset, binhalfwidth = binvec,
  propstatus = propvector)

# POPN C 2003-2004
XC3 <- matrix(c(0, 0, 1.74, 1.74,
0.208333333, 0, 0, 0.057142857,
0.041666667, 0.076923077, 0, 0,
0.083333333, 0.076923077, 0.066666667, 0.028571429), 4, 4, byrow = TRUE)

# 2004-2005
XC4 <- matrix(c(0, 0, 0.3, 0.6,
0.32183908, 0.142857143, 0, 0,
0.16091954, 0.285714286, 0, 0,
0.252873563, 0.285714286, 0.5, 0.6), 4, 4, byrow = TRUE)

# 2005-2006
XC5 <- matrix(c(0, 0, 0.50625, 0.675,
0, 0, 0, 0.035714286,
0.1, 0.068965517, 0.0625, 0.107142857,
0.3, 0.137931034, 0, 0.071428571), 4, 4, byrow = TRUE)

# POPN E 2003-2004
XE3 <- matrix(c(0, 0, 2.44, 6.569230769,
0.196428571, 0, 0, 0,
0.125, 0.5, 0, 0,
0.160714286, 0.5, 0.133333333, 0.076923077), 4, 4, byrow = TRUE)

XE4 <- matrix(c(0, 0, 0.45, 0.646153846,
0.06557377, 0.090909091, 0.125, 0,
0.032786885, 0, 0.125, 0.076923077,
0.049180328, 0, 0.125, 0.230769231), 4, 4, byrow = TRUE)

XE5 <- matrix(c(0, 0, 2.85, 3.99,
0.083333333, 0, 0, 0,
0, 0, 0, 0,
0.416666667, 0.1, 0, 0.1), 4, 4, byrow = TRUE)

mats_list <- list(XC3, XC4, XC5, XE3, XE4, XE5)
yr_ord <- c(1, 2, 3, 1, 2, 3)
pch_ord <- c(1, 1, 1, 2, 2, 2)

anth_lefkoMat <- create_lM(mats_list, anthframe, hstages = NA,
  historical = FALSE, poporder = 1, patchorder = pch_ord, yearorder = yr_ord)
  
smaller_anth_lM <- delete_lM(anth_lefkoMat, patch = 2)

}
\seealso{
\code{\link{create_lM}()}

\code{\link{add_lM}()}

\code{\link{subset_lM}()}
}
