% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gizmo-barcap.R
\name{gizmo_barcap}
\alias{gizmo_barcap}
\title{Guide gizmo: capped colour bar}
\usage{
gizmo_barcap(
  key = "sequence",
  shape = "triangle",
  size = NULL,
  show = NA,
  alpha = NA,
  oob = "keep",
  theme = NULL,
  position = waiver(),
  direction = NULL
)
}
\arguments{
\item{key}{A \link[=key_sequence]{sequence key} specification. Defaults to
\code{\link[=key_sequence]{key_sequence(n = 15)}}. Changing the argument to
\code{key_sequence()} is fine, but changing the key type is not advised.}

\item{shape}{A \link[=cap_options]{cap} specification by providing one of the
following:
\itemize{
\item A cap \verb{<function>}, such as \code{cap_triangle()}.
\item A \verb{<character[1]>} naming a cap function without the '\code{cap_}'-prefix,
e.g. \code{"round"}.
\item A two column \verb{<matrix[n, 2]>} giving coordinates for a cap, like those
created by cap functions such as \code{cap_arch()}.
}}

\item{size}{A \code{\link[grid:unit]{<unit>}} setting the size of the cap. When
\code{NULL} (default), cap size will be proportional to the \code{shape} coordinates
and the \code{legend.key.size} theme setting.}

\item{show}{A \verb{<logical>} to control how caps are displayed at the ends
of the bar. When \code{TRUE}, caps are always displayed. When \code{FALSE}, caps
are never displayed. When \code{NA} (default), caps are displayed when the
data range exceed the limits. When given as \verb{<logical[2]>}, \code{show[1]}
controls the display at the lower end and \code{show[2]} at the upper end.}

\item{alpha}{A \verb{<numeric[1]>} between 0 and 1 setting the colour transparency
of the bar. Use \code{NA} to preserve the alpha encoded in the colour itself.}

\item{oob}{An out-of-bounds handling function that affects the cap colour.
Can be one of the following:
\itemize{
\item A \verb{<function>} like \code{\link[scales:oob]{oob_squish}}.
\item A \verb{<character[1]>} naming such a function without the '\code{oob}'-prefix,
such as \code{"keep"}.
}}

\item{theme}{A \code{\link[ggplot2:theme]{<theme>}} object to style the guide individually or
differently from the plot's theme settings. The \code{theme} argument in the
guide overrides and is combined with the plot's theme.}

\item{position}{A \verb{<character[1]>} giving the location of the guide. Can be one of \code{"top"},
\code{"bottom"}, \code{"left"} or \code{"right"}.}

\item{direction}{A \verb{<character[1]>} indicating the direction of the guide. Can be on of
\code{"horizontal"} or \code{"vertical"}.}
}
\value{
A \verb{<GizmoBarcap>} object.
}
\description{
This guide displays a colour bar with optional caps at either ends of
the bar.
}
\examples{
# A standard plot
p <- ggplot(mpg, aes(displ, hwy, colour = cty)) +
  geom_point()

# Just a bar
p + scale_colour_viridis_c(guide = gizmo_barcap())

# Caps show up when there is data outside the limits
p + scale_colour_viridis_c(
  limits = c(10, 30),
  guide  = gizmo_barcap()
)

# The scale's out-of-bounds handler determines cap colour
p + scale_colour_viridis_c(
  limits = c(10, 30), oob = scales::oob_squish,
  guide = gizmo_barcap()
)

# Customising display of the guide
p +
  scale_colour_viridis_c(
    oob = scales::oob_squish,
    guide = gizmo_barcap(
      shape = "arch", show = c(FALSE, TRUE),
      size = unit(2, "cm"),
      theme = theme(legend.key.height = unit(4, "cm"))
    )
  ) +
  theme(
    legend.frame = element_rect(colour = "black"),
    legend.key.width = unit(0.5, "cm")
  )
}
\seealso{
Other gizmos: 
\code{\link{gizmo_density}()},
\code{\link{gizmo_grob}()},
\code{\link{gizmo_histogram}()},
\code{\link{gizmo_stepcap}()}
}
\concept{gizmos}
