#' NRC Emotions
#'
#' A \pkg{data.table} dataset containing Mohammad & Turney', P. D.'s (2010)
#' emotions word list as a binary table.
#'
#' @details
#' \itemize{
#'   \item term. A term
#'   \item anger. Counts of anger anger
#'   \item anticipation. Counts of anticipation
#'   \item disgust. Counts of disgust
#'   \item fear. Counts of fear
#'   \item joy. Counts of joy
#'   \item sadness. Counts of sadness
#'   \item surprise. Counts of surprise
#'   \item trust. Counts of trust
#' }
#' 
#' @section License: The original authors note the data is available for 
#' non-commercial use: "If interested in commercial use of any of these lexicons, 
#' send email to Saif M. Mohammad (Senior Research Officer at NRC and creator of 
#' these lexicons): saif.mohammad@@nrc-cnrc.gc.ca and Pierre Charron (Client 
#' Relationship Leader at NRC): Pierre.Charron@@nrc-cnrc.gc.ca. A nominal 
#' one-time licensing fee may apply."
#' @docType data
#' @keywords datasets
#' @name nrc_emotions
#' @usage data(nrc_emotions)
#' @format A data frame with 14182 rows and 9 variables
#' @references http://www.purl.com/net/lexicons  \cr \cr
#' Mohammad, S. M. & Turney, P. D. (2010) Emotions evoked by common words and
#' phrases: Using Mechanical Turk to create an emotion lexicon, In Proceeding of
#' Workshop on Computational Approaches to Analysis and Generation of Emotion in
#' Text, 26-34.
NULL
