\name{getZmat}
\alias{getZmat}
\title{getZmat function}
\usage{
getZmat(formula, data, regionalcovariates = NULL, pixelcovariates = NULL,
  cellwidth, ext = 2, inclusion = "touching", overl = NULL)
}
\arguments{
  \item{formula}{a formula object of the form X ~ var1 +
  var2 etc. The name of the dependent variable must be "X".
  Only accepts 'simple' formulae, such as the example
  given.}

  \item{data}{the data to be analysed (using, for example
  lgcpPredictSpatialPlusPars). Either an object of class
  ppp, or an object of class SpatialPolygonsDataFrame}

  \item{regionalcovariates}{an optional
  SpatialPolygonsDataFrame object containing covariate
  information, if applicable}

  \item{pixelcovariates}{an optional SpatialPixelsDataFrame
  object containing covariate information, if applicable}

  \item{cellwidth}{the width of computational cells}

  \item{ext}{integer multiple by which grid should be
  extended, default is 2. Generally this will not need to
  be altered, but if the spatial correlation decays slowly,
  increasing 'ext' may be necessary.}

  \item{inclusion}{criterion for cells being included into
  observation window. Either 'touching' or 'centroid'. The
  former, the default, includes all cells that touch the
  observation window, the latter includes all cells whose
  centroids are inside the observation window.}

  \item{overl}{an object of class "lgcppolyol", created by
  the function getpolyol. Such an object contains the FFT
  grid and a polygon/polygon overlay and speeds up
  computation massively.}
}
\value{
a design matrix for passing on to the Bayesian MCMC
functions
}
\description{
A function to construct a design matrix for use with the
Bayesian MCMC routines in lgcp. See the vignette
"Bayesian_lgcp" for further details on how to use this
function.\cr
}
\details{
For example, a spatial LGCP model for the would have the
form:\cr \cr X(s) ~ Poisson[R(s)]\cr \cr R(s) = C_A
lambda(s) exp[Z(s)beta+Y(s)]\cr \cr

The function getZmat helps create the matrix Z. The
returned object is passed onto an MCMC function, for
example lgcpPredictSpatialPlusPars or
lgcpPredictAggregateSpatialPlusPars. This function can also
be used to help construct Z for use with
lgcpPredictSpatioTemporalPlusPars and
lgcpPredictMultitypeSpatialPlusPars, but these functions
require a list of such objects: see the vignette
"Bayesian_lgcp" for examples.
}
\seealso{
\link{minimum.contrast},
\link{minimum.contrast.spatiotemporal},
\link{chooseCellwidth}, \link{getpolyol},
\link{guessinterp}, \link{addTemporalCovariates},
\link{lgcpPrior}, \link{lgcpInits}, \link{CovFunction}
\link{lgcpPredictSpatialPlusPars},
\link{lgcpPredictAggregateSpatialPlusPars},
\link{lgcpPredictSpatioTemporalPlusPars},
\link{lgcpPredictMultitypeSpatialPlusPars}
}

