% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-lgpfit.R
\name{get_draws}
\alias{get_draws}
\title{Extract parameter draws from lgpfit or stanfit}
\usage{
get_draws(object, draws = NULL, reduce = NULL, ...)
}
\arguments{
\item{object}{An object of class \linkS4class{lgpfit} or \code{stanfit}.}

\item{draws}{Indices of the parameter draws. \code{NULL} corresponds to
all post-warmup draws.}

\item{reduce}{Function used to reduce all parameter draws into
one set of parameters. Ignored if \code{NULL}, or if \code{draws} is not
\code{NULL}.}

\item{...}{Additional arguments to \code{rstan::extract()}.}
}
\value{
The return value is always a 2-dimensional array of shape
\code{num_param_sets} x \code{num_params}.
}
\description{
Uses \code{\link[rstan]{extract}}
with \code{permuted = FALSE} and \code{inc_warmup = FALSE}.
}
\seealso{
Other main functions: 
\code{\link{create_model}()},
\code{\link{draw_pred}()},
\code{\link{lgp}()},
\code{\link{pred}()},
\code{\link{prior_pred}()},
\code{\link{sample_model}()}
}
\concept{main functions}
