% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{print.lib}
\alias{print.lib}
\title{Print a data library}
\usage{
\method{print}{lib}(x, ..., verbose = FALSE)
}
\arguments{
\item{x}{The library to print.}

\item{...}{Any follow-on parameters.}

\item{verbose}{Whether or not to print the library in verbose style.
By default, the parameter is FALSE, meaning to print in summary style.}
}
\value{
The object, invisibly.
}
\description{
A class-specific instance of the \code{print} function for 
data libraries.  The function prints the library in a summary manner.  
Use \code{verbose = TRUE} to print the library as a list.
}
\examples{
# Create temp directory
tmp <- tempdir()

# Create data library
libname(dat, tmp)

# Add data to library
lib_add(dat, iris, ToothGrowth, PlantGrowth)

# Print library summary 
print(dat)
# library 'dat': 3 items
# - attributes: not loaded
# - path: C:\Users\User\AppData\Local\Temp\RtmpCSJ6Gc
# - items:
#          Name Extension Rows Cols   Size        LastModified
# 1        iris       rds  150    5 7.8 Kb 2020-11-05 22:26:59
# 2 PlantGrowth       rds   30    2 2.5 Kb 2020-11-05 22:26:59
# 3 ToothGrowth       rds   60    3 3.4 Kb 2020-11-05 22:26:59

# Clean up
lib_delete(dat)
}
\seealso{
Other lib: 
\code{\link{is.lib}()},
\code{\link{lib_add}()},
\code{\link{lib_copy}()},
\code{\link{lib_delete}()},
\code{\link{lib_export}()},
\code{\link{lib_info}()},
\code{\link{lib_load}()},
\code{\link{lib_path}()},
\code{\link{lib_remove}()},
\code{\link{lib_replace}()},
\code{\link{lib_size}()},
\code{\link{lib_sync}()},
\code{\link{lib_unload}()},
\code{\link{lib_write}()},
\code{\link{libname}()}
}
\concept{lib}
