/* libsoc - Library to handle standardised output files
 * Copyright (C) 2015 Rikard Nordgren
 * 
 * This file was autogenerated and should not be edited
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * his library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */

#include <R.h>
#include <Rdefines.h>
#include <so.h>
#include "soc.h"

SEXP r_so_ExternalFile_new()
{
	so_ExternalFile *obj = so_ExternalFile_new();
	if (!obj) {
		error("Failed to create so_ExternalFile object");
	}
	return R_MakeExternalPtr(obj, R_NilValue, R_NilValue);
}

SEXP r_so_ExternalFile_copy(SEXP self)
{
	so_ExternalFile *obj = so_ExternalFile_copy(R_ExternalPtrAddr(self));
	if (!obj) {
		error("Failed to copy so_ExternalFile object");
	}
	return R_MakeExternalPtr(obj, R_NilValue, R_NilValue);
}

SEXP r_so_ExternalFile_free(SEXP self)
{
	so_ExternalFile_free(R_ExternalPtrAddr(self));
	return R_NilValue;
}

SEXP r_so_ExternalFile_ref(SEXP self)
{
	so_ExternalFile_ref(R_ExternalPtrAddr(self));
	return R_NilValue;
}

SEXP r_so_ExternalFile_unref(SEXP self)
{
	so_ExternalFile_unref(R_ExternalPtrAddr(self));
	return R_NilValue;
}

SEXP r_so_ExternalFile_get_Description(SEXP self)
{
	char *child = so_ExternalFile_get_Description(R_ExternalPtrAddr(self));
	if (!child) {
		return R_NilValue;
	}
	SEXP result;
	PROTECT(result = NEW_STRING(1));
	SET_STRING_ELT(result, 0, mkChar(child));
	UNPROTECT(1);
	return result;
}

SEXP r_so_ExternalFile_set_Description(SEXP self, SEXP child)
{
	int fail = so_ExternalFile_set_Description(R_ExternalPtrAddr(self), (char *) CHAR(STRING_ELT(child, 0)));
	if (fail) {
		error("so_ExternalFile_set_Description failed");
	}
	return R_NilValue;
}


SEXP r_so_ExternalFile_get_path(SEXP self)
{
	char *child = so_ExternalFile_get_path(R_ExternalPtrAddr(self));
	if (!child) {
		return R_NilValue;
	}
	SEXP result;
	PROTECT(result = NEW_STRING(1));
	SET_STRING_ELT(result, 0, mkChar(child));
	UNPROTECT(1);
	return result;
}

SEXP r_so_ExternalFile_set_path(SEXP self, SEXP child)
{
	int fail = so_ExternalFile_set_path(R_ExternalPtrAddr(self), (char *) CHAR(STRING_ELT(child, 0)));
	if (fail) {
		error("so_ExternalFile_set_path failed");
	}
	return R_NilValue;
}


SEXP r_so_ExternalFile_get_format(SEXP self)
{
	char *child = so_ExternalFile_get_format(R_ExternalPtrAddr(self));
	if (!child) {
		return R_NilValue;
	}
	SEXP result;
	PROTECT(result = NEW_STRING(1));
	SET_STRING_ELT(result, 0, mkChar(child));
	UNPROTECT(1);
	return result;
}

SEXP r_so_ExternalFile_set_format(SEXP self, SEXP child)
{
	int fail = so_ExternalFile_set_format(R_ExternalPtrAddr(self), (char *) CHAR(STRING_ELT(child, 0)));
	if (fail) {
		error("so_ExternalFile_set_format failed");
	}
	return R_NilValue;
}


SEXP r_so_ExternalFile_get_delimiter(SEXP self)
{
	char *child = so_ExternalFile_get_delimiter(R_ExternalPtrAddr(self));
	if (!child) {
		return R_NilValue;
	}
	SEXP result;
	PROTECT(result = NEW_STRING(1));
	SET_STRING_ELT(result, 0, mkChar(child));
	UNPROTECT(1);
	return result;
}

SEXP r_so_ExternalFile_set_delimiter(SEXP self, SEXP child)
{
	int fail = so_ExternalFile_set_delimiter(R_ExternalPtrAddr(self), (char *) CHAR(STRING_ELT(child, 0)));
	if (fail) {
		error("so_ExternalFile_set_delimiter failed");
	}
	return R_NilValue;
}


SEXP r_so_ExternalFile_get_MissingData(SEXP self, SEXP index)
{
	so_MissingData *child = so_ExternalFile_get_MissingData(R_ExternalPtrAddr(self), INTEGER(index)[0]);
	SEXP result = R_MakeExternalPtr(child, R_NilValue, R_NilValue);
	return result;
}

SEXP r_so_ExternalFile_get_number_of_MissingData(SEXP self)
{
	int number = so_ExternalFile_get_number_of_MissingData(R_ExternalPtrAddr(self));
	SEXP r_int = PROTECT(NEW_INTEGER(1));
	INTEGER(r_int)[0] = number;
	UNPROTECT(1);
	return r_int;
}
SEXP r_so_ExternalFile_add_MissingData(SEXP self, SEXP child)
{
	int fail = so_ExternalFile_add_MissingData(R_ExternalPtrAddr(self), R_ExternalPtrAddr(child));
	if (fail) {
		error("Failed to add MissingData to ExternalFile");
	}
	return(R_NilValue);
}
SEXP r_so_ExternalFile_remove_MissingData(SEXP self, SEXP index)
{
	int fail = so_ExternalFile_remove_MissingData(R_ExternalPtrAddr(self), INTEGER(index)[0]);
	if (fail) {
		error("Failed to remove MissingData from ExternalFile");
	}
	return(R_NilValue);
}
SEXP r_so_ExternalFile_create_MissingData(SEXP self)
{
	so_MissingData *child = so_ExternalFile_create_MissingData(R_ExternalPtrAddr(self));
	return R_MakeExternalPtr(child, R_NilValue, R_NilValue);
}

SEXP r_so_ExternalFile_get_oid(SEXP self)
{
	char *value = so_ExternalFile_get_oid(R_ExternalPtrAddr(self));

	SEXP result;

	if (value) {
		result = PROTECT(NEW_STRING(1));
		SET_STRING_ELT(result, 0, mkChar(value));

		UNPROTECT(1);
	} else {
		result = R_NilValue;
	}
	return result;
}

SEXP r_so_ExternalFile_set_oid(SEXP self, SEXP string)
{
	char *c_string = (char *) CHAR(STRING_ELT(string, 0));
	int fail = so_ExternalFile_set_oid(R_ExternalPtrAddr(self), c_string);
	if (fail) {
		error("so_ExternalFile_set_oid failed");
	}

	return R_NilValue;
}

