/* libsoc - Library to handle standardised output files
 * Copyright (C) 2015 Rikard Nordgren
 * 
 * This file was autogenerated and should not be edited
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * his library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */
#ifndef _SO_BAYESIAN_H
#define _SO_BAYESIAN_H

#include <so/Table.h>

/** \struct so_Bayesian
	 \brief A structure representing an SO/SOBlock/Estimation/PopulationEstimates/Bayesian element
*/
typedef struct so_Bayesian so_Bayesian;

/** \memberof so_Bayesian
 * Create a new empty so_Bayesian structure.
 * \return A pointer to the newly created struct or NULL if memory allocation failed
 * \sa so_Bayesian_copy, so_Bayesian_free
 */
so_Bayesian *so_Bayesian_new();
/** \memberof so_Bayesian
 * Create a copy of a so_Bayesian structure.
 * \return A pointer to the newly created struct or NULL if memory allocation failed
 * \sa so_Bayesian_new
 */
so_Bayesian *so_Bayesian_copy(so_Bayesian *self);
/** \memberof so_Bayesian
 * Free all memory associated with a so_Bayesian structure and its children.
 * \param self - a pointer to the structure to free
 * \sa so_Bayesian_new
 */
void so_Bayesian_free(so_Bayesian *self);
void so_Bayesian_ref(so_Bayesian *self);
void so_Bayesian_unref(so_Bayesian *self);
/** \memberof so_Bayesian
 * Get the PosteriorMean element
 * \param self - pointer to a so_Bayesian
 * \return A pointer to the structure representing the PosteriorMean element
 * \sa so_Bayesian_set_PosteriorMean
 */
so_Table *so_Bayesian_get_PosteriorMean(so_Bayesian *self);
/** \memberof so_Bayesian
 * Get the PosteriorMedian element
 * \param self - pointer to a so_Bayesian
 * \return A pointer to the structure representing the PosteriorMedian element
 * \sa so_Bayesian_set_PosteriorMedian
 */
so_Table *so_Bayesian_get_PosteriorMedian(so_Bayesian *self);
/** \memberof so_Bayesian
 * Get the PosteriorMode element
 * \param self - pointer to a so_Bayesian
 * \return A pointer to the structure representing the PosteriorMode element
 * \sa so_Bayesian_set_PosteriorMode
 */
so_Table *so_Bayesian_get_PosteriorMode(so_Bayesian *self);
/** \memberof so_Bayesian
 * Set the PosteriorMean element
 * \param self - pointer to a so_Bayesian
 * \param value - A pointer to a \a so_Table to set.
 * \sa so_Bayesian_get_PosteriorMean
 */
void so_Bayesian_set_PosteriorMean(so_Bayesian *self, so_Table *value);
/** \memberof so_Bayesian
 * Set the PosteriorMedian element
 * \param self - pointer to a so_Bayesian
 * \param value - A pointer to a \a so_Table to set.
 * \sa so_Bayesian_get_PosteriorMedian
 */
void so_Bayesian_set_PosteriorMedian(so_Bayesian *self, so_Table *value);
/** \memberof so_Bayesian
 * Set the PosteriorMode element
 * \param self - pointer to a so_Bayesian
 * \param value - A pointer to a \a so_Table to set.
 * \sa so_Bayesian_get_PosteriorMode
 */
void so_Bayesian_set_PosteriorMode(so_Bayesian *self, so_Table *value);
/** \memberof so_Bayesian
 * Create a new PosteriorMean element and insert it into the so_Bayesian
 * \param self - pointer to a so_Bayesian
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_Table *so_Bayesian_create_PosteriorMean(so_Bayesian *self);
/** \memberof so_Bayesian
 * Create a new PosteriorMedian element and insert it into the so_Bayesian
 * \param self - pointer to a so_Bayesian
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_Table *so_Bayesian_create_PosteriorMedian(so_Bayesian *self);
/** \memberof so_Bayesian
 * Create a new PosteriorMode element and insert it into the so_Bayesian
 * \param self - pointer to a so_Bayesian
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_Table *so_Bayesian_create_PosteriorMode(so_Bayesian *self);

#endif
