/* libsoc - Library to handle standardised output files
 * Copyright (C) 2015 Rikard Nordgren
 * 
 * This file was autogenerated and should not be edited
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * his library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */
#ifndef _SO_MISSINGDATA_H
#define _SO_MISSINGDATA_H


/** \struct so_MissingData
	 \brief A structure representing an MissingData element
*/
typedef struct so_MissingData so_MissingData;

/** \memberof so_MissingData
 * Create a new empty so_MissingData structure.
 * \return A pointer to the newly created struct or NULL if memory allocation failed
 * \sa so_MissingData_copy, so_MissingData_free
 */
so_MissingData *so_MissingData_new();
/** \memberof so_MissingData
 * Create a copy of a so_MissingData structure.
 * \return A pointer to the newly created struct or NULL if memory allocation failed
 * \sa so_MissingData_new
 */
so_MissingData *so_MissingData_copy(so_MissingData *self);
/** \memberof so_MissingData
 * Free all memory associated with a so_MissingData structure and its children.
 * \param self - a pointer to the structure to free
 * \sa so_MissingData_new
 */
void so_MissingData_free(so_MissingData *self);
void so_MissingData_ref(so_MissingData *self);
void so_MissingData_unref(so_MissingData *self);
/** \memberof so_MissingData
 * Get the value of the dataCode attribute
 * \param self - pointer to a so_MissingData
 * \return A pointer to the attribute value
 * \sa so_MissingData_set_dataCode
 */
char *so_MissingData_get_dataCode(so_MissingData *self);
/** \memberof so_MissingData
 * Set the value of the dataCode attribute
 * \param self - pointer to a so_MissingData
 * \param value - A pointer to the attribute value
 * \return 0 for success
 * \sa so_MissingData_get_dataCode
 */
int so_MissingData_set_dataCode(so_MissingData *self, char *value);
/** \memberof so_MissingData
 * Get the value of the missingDataType attribute
 * \param self - pointer to a so_MissingData
 * \return A pointer to the attribute value
 * \sa so_MissingData_set_missingDataType
 */
char *so_MissingData_get_missingDataType(so_MissingData *self);
/** \memberof so_MissingData
 * Set the value of the missingDataType attribute
 * \param self - pointer to a so_MissingData
 * \param value - A pointer to the attribute value
 * \return 0 for success
 * \sa so_MissingData_get_missingDataType
 */
int so_MissingData_set_missingDataType(so_MissingData *self, char *value);

#endif
