/* libsoc - Library to handle standardised output files
 * Copyright (C) 2015 Rikard Nordgren
 * 
 * This file was autogenerated and should not be edited
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * his library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */
#ifndef _SO_MODELDIAGNOSTIC_H
#define _SO_MODELDIAGNOSTIC_H

#include <so/DiagnosticStructuralModel.h>
#include <so/DiagnosticIndividualParams.h>

/** \struct so_ModelDiagnostic
	 \brief A structure representing an SO/SOBlock/ModelDiagnostic element
*/
typedef struct so_ModelDiagnostic so_ModelDiagnostic;

/** \memberof so_ModelDiagnostic
 * Create a new empty so_ModelDiagnostic structure.
 * \return A pointer to the newly created struct or NULL if memory allocation failed
 * \sa so_ModelDiagnostic_copy, so_ModelDiagnostic_free
 */
so_ModelDiagnostic *so_ModelDiagnostic_new();
/** \memberof so_ModelDiagnostic
 * Create a copy of a so_ModelDiagnostic structure.
 * \return A pointer to the newly created struct or NULL if memory allocation failed
 * \sa so_ModelDiagnostic_new
 */
so_ModelDiagnostic *so_ModelDiagnostic_copy(so_ModelDiagnostic *self);
/** \memberof so_ModelDiagnostic
 * Free all memory associated with a so_ModelDiagnostic structure and its children.
 * \param self - a pointer to the structure to free
 * \sa so_ModelDiagnostic_new
 */
void so_ModelDiagnostic_free(so_ModelDiagnostic *self);
void so_ModelDiagnostic_ref(so_ModelDiagnostic *self);
void so_ModelDiagnostic_unref(so_ModelDiagnostic *self);
/** \memberof so_ModelDiagnostic
 * Get the DiagnosticStructuralModel element
 * \param self - pointer to a so_ModelDiagnostic
 * \return A pointer to the structure representing the DiagnosticStructuralModel element
 * \sa so_ModelDiagnostic_set_DiagnosticStructuralModel
 */
so_DiagnosticStructuralModel *so_ModelDiagnostic_get_DiagnosticStructuralModel(so_ModelDiagnostic *self);
/** \memberof so_ModelDiagnostic
 * Get the DiagnosticIndividualParams element
 * \param self - pointer to a so_ModelDiagnostic
 * \return A pointer to the structure representing the DiagnosticIndividualParams element
 * \sa so_ModelDiagnostic_set_DiagnosticIndividualParams
 */
so_DiagnosticIndividualParams *so_ModelDiagnostic_get_DiagnosticIndividualParams(so_ModelDiagnostic *self);
/** \memberof so_ModelDiagnostic
 * Set the DiagnosticStructuralModel element
 * \param self - pointer to a so_ModelDiagnostic
 * \param value - A pointer to a \a so_DiagnosticStructuralModel to set.
 * \sa so_ModelDiagnostic_get_DiagnosticStructuralModel
 */
void so_ModelDiagnostic_set_DiagnosticStructuralModel(so_ModelDiagnostic *self, so_DiagnosticStructuralModel *value);
/** \memberof so_ModelDiagnostic
 * Set the DiagnosticIndividualParams element
 * \param self - pointer to a so_ModelDiagnostic
 * \param value - A pointer to a \a so_DiagnosticIndividualParams to set.
 * \sa so_ModelDiagnostic_get_DiagnosticIndividualParams
 */
void so_ModelDiagnostic_set_DiagnosticIndividualParams(so_ModelDiagnostic *self, so_DiagnosticIndividualParams *value);
/** \memberof so_ModelDiagnostic
 * Create a new DiagnosticStructuralModel element and insert it into the so_ModelDiagnostic
 * \param self - pointer to a so_ModelDiagnostic
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_DiagnosticStructuralModel *so_ModelDiagnostic_create_DiagnosticStructuralModel(so_ModelDiagnostic *self);
/** \memberof so_ModelDiagnostic
 * Create a new DiagnosticIndividualParams element and insert it into the so_ModelDiagnostic
 * \param self - pointer to a so_ModelDiagnostic
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_DiagnosticIndividualParams *so_ModelDiagnostic_create_DiagnosticIndividualParams(so_ModelDiagnostic *self);

#endif
