/* libsoc - Library to handle standardised output files
 * Copyright (C) 2015 Rikard Nordgren
 * 
 * This file was autogenerated and should not be edited
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * his library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */
#ifndef _SO_PRIVATE_OPTIMALDESIGNBLOCK_H
#define _SO_PRIVATE_OPTIMALDESIGNBLOCK_H

#include <libxml/xmlwriter.h>

#include <so/private/Matrix.h>
#include <so/private/Table.h>
#include <so/private/ExternalFile.h>

struct so_OptimalDesignBlock {
	int *blockNumber;
	int blockNumber_number;
	so_Matrix *FIM;
	so_Matrix *CovarianceMatrix;
	so_Table *ParameterPrecision;
	so_Table *Criteria;
	so_Table *Tests;
	so_ExternalFile *SimulatedData;
	so_ExternalFile *Design;
	int in_FIM;
	int in_CovarianceMatrix;
	int in_ParameterPrecision;
	int in_Criteria;
	int in_Tests;
	int in_SimulatedData;
	int in_Design;
	int reference_count;
};

int so_OptimalDesignBlock_start_element(so_OptimalDesignBlock *self, const char *localname, int nb_attributes, const char **attributes);
void so_OptimalDesignBlock_end_element(so_OptimalDesignBlock *self, const char *localname);
int so_OptimalDesignBlock_characters(so_OptimalDesignBlock *self, const char *ch, int len);
int so_OptimalDesignBlock_xml(so_OptimalDesignBlock *self, xmlTextWriterPtr writer);
int so_OptimalDesignBlock_init_attributes(so_OptimalDesignBlock *self, int nb_attributes, const char **attributes);

#endif
