% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lasgetters.r
\name{lasfilters}
\alias{lasfilterfirst}
\alias{lasfilterfirstlast}
\alias{lasfilterfirstofmany}
\alias{lasfilterground}
\alias{lasfilterlast}
\alias{lasfilternth}
\alias{lasfilters}
\alias{lasfiltersingle}
\title{Predefined filters}
\usage{
lasfilterfirst(.las)

lasfilterfirstlast(.las)

lasfilterfirstofmany(.las)

lasfilterground(.las)

lasfilterlast(.las)

lasfilternth(.las, n)

lasfiltersingle(.las)

lasfilterfirstofmany(.las)
}
\arguments{
\item{.las}{An object of class \code{\link[lidR:LAS-class]{LAS}}}

\item{n}{the position in the return sequence}
}
\value{
An object of class \code{\link[lidR:LAS-class]{LAS}}
}
\description{
Select only some returns
}
\details{
\itemize{
\item{\code{lasfilterfirst} Select only the first returns.}
\item{\code{lasfilterfirstlast} Select only the first and last returns.}
\item{\code{lasfilterground} Select only the returns classified as ground according to LAS specification v1.3.}
\item{\code{lasfilterlast} Select only the last returns i.e. the last returns and the single returns.}
\item{\code{lasfilternth} Select the returns from their position in the return sequence.}
\item{\code{lasfilterfirstofmany} Select only the first returns from pulses which returned multiple points.}
\item{\code{lasfiltersingle} Select only the returns which return only one point.}
}
}
\examples{
LASfile <- system.file("extdata", "Megaplot.laz", package="lidR")
lidar = readLAS(LASfile)

firstReturns  = lidar \%>\% lasfilterfirst
groundReturns = lidar \%>\% lasfilterground
}
\seealso{
Other lasfilters: \code{\link{lasfilter}}

Other lasfilters: \code{\link{lasfilter}}

Other lasfilters: \code{\link{lasfilter}}

Other lasfilters: \code{\link{lasfilter}}

Other lasfilters: \code{\link{lasfilter}}

Other lasfilters: \code{\link{lasfilter}}

Other lasfilters: \code{\link{lasfilter}}

Other lasfilters: \code{\link{lasfilter}}

Other lasfilters: \code{\link{lasfilter}}
}

