% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/catalog_select.r
\name{catalog_select}
\alias{catalog_select}
\title{Select LAS files manually from a LAScatalog}
\usage{
catalog_select(ctg, mapview = TRUE)
}
\arguments{
\item{ctg}{A \link[lidR:LAScatalog-class]{LAScatalog} object}

\item{mapview}{logical. If \code{FALSE}, use R base plot instead of mapview (no pan, no zoom, see
also \link[lidR:plot]{plot})}
}
\value{
A LAScatalog object
}
\description{
Select a set of LAS tiles from a LAScatalog interactively using the mouse. This function
allows users to subset a LAScatalog by clicking on a map of the file.
}
\examples{
\dontrun{
ctg = readLAScatalog("<Path to a folder containing a set of .las files>")
new_ctg = catalog_select(ctg)
}
}
