% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-LAS.R, R/methods-LAScatalog.R
\name{$<-,LAS-method}
\alias{$<-,LAS-method}
\alias{[[<-,LAS,ANY,missing-method}
\alias{[,LAS,numeric,ANY-method}
\alias{[,LAScatalog,ANY,ANY-method}
\alias{[[<-,LAScatalog,ANY,ANY-method}
\alias{$<-,LAScatalog-method}
\title{Inherited but modified methods from sp}
\usage{
\S4method{$}{LAS}(x, name) <- value

\S4method{[[}{LAS,ANY,missing}(x, i, j) <- value

\S4method{[}{LAS,numeric,ANY}(x, i)

\S4method{[}{LAScatalog,ANY,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[[}{LAScatalog,ANY,ANY}(x, i, j) <- value

\S4method{$}{LAScatalog}(x, name) <- value
}
\arguments{
\item{x}{A \code{LAS*} object}

\item{name}{A literal character string or a name (possibly backtick quoted).}

\item{value}{typically an array-like R object of a similar class as x.}

\item{i}{string, name of elements to extract or replace.}

\item{j}{Unused.}

\item{...}{Unused}

\item{drop}{Unused}
}
\description{
\code{LAS*} objects are \link[sp:Spatial-class]{Spatial} objects so they inherit several methods
from \code{sp}. However, some have modified behaviors to prevent some irrelevant modifications. Indeed,
a \code{LAS*} object cannot contain anything, as the content is restricted by the LAS specifications.
If a user attempts to use one of these functions inappropriately an informative error will be thrown.
}
\examples{
\dontrun{
LASfile <- system.file("extdata", "Megaplot.laz", package="lidR")
las = readLAS(LASfile)

las$Z = 2L
las[["Z"]] = 1:10
las$NewCol = 0
las[["NewCol"]] = 0
}
}
