% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_crs.R
\name{st_crs}
\alias{st_crs}
\alias{st_crs.LAS}
\alias{st_crs.LAScatalog}
\alias{st_crs.LASheader}
\alias{st_crs.LAScluster}
\alias{st_crs<-}
\alias{st_crs<-.LAS}
\alias{st_crs<-.LASheader}
\alias{st_crs<-.LAScatalog}
\alias{projection}
\alias{projection<-}
\alias{crs}
\alias{crs<-}
\alias{crs,LASheader-method}
\alias{crs,LAS-method}
\alias{crs<-,LAS-method}
\alias{crs,LAScatalog-method}
\alias{crs,LAScluster-method}
\alias{crs<-,LAScatalog-method}
\alias{crs<-,LASheader-method}
\alias{epsg}
\alias{epsg<-}
\alias{epsg,LASheader-method}
\alias{epsg<-,LASheader-method}
\alias{epsg,LAS-method}
\alias{epsg<-,LAS-method}
\alias{wkt}
\alias{wkt<-}
\alias{wkt,LASheader-method}
\alias{wkt<-,LASheader-method}
\alias{wkt,LAS-method}
\alias{wkt<-,LAS-method}
\title{Get or set the projection of a LAS* object}
\usage{
\method{st_crs}{LAS}(x, ...)

\method{st_crs}{LAScatalog}(x, ...)

\method{st_crs}{LASheader}(x, ...)

\method{st_crs}{LAScluster}(x, ...)

\method{st_crs}{LAS}(x) <- value

\method{st_crs}{LASheader}(x) <- value

\method{st_crs}{LAScatalog}(x) <- value

projection(x, asText = TRUE)

projection(x) <- value

crs(x, asText = FALSE)

crs(x, ...) <- value

\S4method{crs}{LASheader}(x, asText = FALSE)

\S4method{crs}{LAS}(x, asText = FALSE)

\S4method{crs}{LAS}(x, ...) <- value

\S4method{crs}{LAScatalog}(x, asText = FALSE)

\S4method{crs}{LAScluster}(x, asText = FALSE)

\S4method{crs}{LAScatalog}(x, ...) <- value

\S4method{crs}{LASheader}(x, ...) <- value

epsg(object, ...)

epsg(object) <- value

\S4method{epsg}{LASheader}(object, ...)

\S4method{epsg}{LASheader}(object) <- value

\S4method{epsg}{LAS}(object)

\S4method{epsg}{LAS}(object) <- value

wkt(obj)

wkt(obj) <- value

\S4method{wkt}{LASheader}(obj)

\S4method{wkt}{LASheader}(obj) <- value

\S4method{wkt}{LAS}(obj)

\S4method{wkt}{LAS}(obj) <- value
}
\arguments{
\item{x, object, obj}{An object of class LAS*}

\item{...}{Unused.}

\item{value}{A \code{CRS} or a \code{crs} or a \code{proj4string} string or WKT string or an EPSG code.}

\item{asText}{logical. If TRUE, the projection is returned as text. Otherwise a CRS object is returned.}
}
\value{
A \code{st_crs()} returns a \code{sf::crs}. \code{projection()} and \code{crs()} return a \code{sp::CRS} and should
no longer be used.
}
\description{
Get or set the projection of a \verb{LAS*} object.  \code{st_crs()} extends \code{sf:st_crs()}, \code{projection()} and
\code{crs()} extend \code{raster:projection()} and \code{raster:crs()}. \code{projection()} and \code{crs()} are provided
for backward compatibility. For \code{epsg()} and \code{wkt()}, see details.
}
\details{
There are two ways to store the CRS of a point cloud in a LAS file:
\itemize{
\item Store an EPSG code (for LAS 1.0 to 1.3)
\item Store a WTK string (for LAS 1.4)
}

On the other hand, R spatial packages use a \code{crs} object to store the CRS. This is why the CRS is duplicated
in a LAS object. The information belongs within the header in a format that can be written in a
LAS file and in the slot \code{crs}, and also in a format that can be understood by other R packages.
\itemize{
\item \code{st_crs} return the CRS in \code{sf} format.
\item \verb{st_crs<-}: assigns a CRS from a \code{CRS} (\code{sp}), a \code{crs} (\code{sf}), a WKT
string, a proj4string or an epsg code. It updates the header of the LAS
object either with the EPSG code for LAS formats < 1.4 or with a WKT string
\item \code{epsg}: reads the epsg code from the header.
\item \code{wkt}: reads the WKT string from the header.
}
}
\examples{
LASfile <- system.file("extdata", "Megaplot.laz", package="lidR")
las <- readLAS(LASfile)

# Get the EPSG code stored in the header (returns 0 if not recorded)
epsg(las)

# Get the WKT string stored in the header (LAS >= 1.4)
wkt(las)

# Overwrite the CRS (but does not reproject)
st_crs(las) <- 26918
las

}
