#' @importFrom data.table :=
#' @import Rcpp
.onAttach <- function(libname, pkgname)
{
  # Runs when attached to search() path such as by library() or require()
  if (!interactive()) return(invisible())

  v = utils::packageVersion("lidR") # nocov
  packageStartupMessage("lidR ", v, " using ", getThreads(), " threads. Help on <gis.stackexchange.com>. Bug report on <github.com/r-lidar/lidR>.") # nocov
}

# nocov start
.onLoad <- function(libname, pkgname)
{
  op <- options()
  op.lidR <- list(
    lidR.progress = TRUE,
    lidR.progress.delay = 2,
    lidR.verbose = FALSE,
    lidR.debug = FALSE,
    lidR.check.nested.parallelism = TRUE,
    lidR.raster.default = "terra")

  max <- R_omp_get_max_threads()
  if (max > 0)
  {
    LIDRTHREADS$n <- as.integer(max/2)
    LIDRTHREADS$input <- as.integer(max/2)
  }

  toset <- !(names(op.lidR) %in% names(op))
  if (any(toset)) options(op.lidR[toset])

  invisible()
}

.onUnload <- function(libpath)
{
  library.dynam.unload("lidR", libpath)
}
# nocov end

.datatable.aware = TRUE

# ,@@@
#  @@@@@@.@                                                           ,#*
#   @@@@@....*&                                                 @(@@@@@@%
#    &@@@......./(                                         .&.....@@@@@
#      @@%.........@                                    ,*........@@@@
#       @@...........@                                @..........@@@@
#         @...........*.                            /............@@
#           @...........@                         *.............@           *@@(@
#             @..........(  %,................@ &............#.       (@*.......@
#               *.........................................*(     %@.............%
#                  /,..&...............................@    ,@..................
#                     ...............................*  #&.....................&
#                    .................................&........................&
#                   @.........................................................,
#                   @.....@@@.................,@@%.....#......................@
#                   &...@@@   *..............@  %@@....&......................
#                   @...@&@@@@*..............@@@@@&....@..................*@%
#                   ......@@&......../&........@@/.....(...........@&
#                  @@##@.............................,*.@....@
#                  %(((((@......#...#%,@..........#(((((@.....,
#                  @((((((%......................%((((((@.......@
#                   @(((((.......................@(((((#..........@
#                    (((&.........................&(((@  @..........&
#                     @.@...........................@.    /,........,@
#                     /....&.....................(,... @........
#                    /......................./*.......&.....@
#                    ..............******..............%..(,/
#                  /....................................%((((&
#                 @...............#.......,..............@
#                &.......................@................&
#               %..................@...../............@....@
#              &...................&....*.................../
#         @....@.....@............./....@............@......@ @/%
#         @(.@...@.................*....@...........#......@..../#
#          ,*****...../............*****@..........,...../.,**%,
#            @*****................&****@........./......*****&
#              /*********@.........@****/........%***,.*****@
#                /*********........%(**(@.......&*********@
#                  @**&     .&.@#        %#.,.. .@(@***@
