% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree.detection.R
\name{rasterZonalStats}
\alias{rasterZonalStats}
\title{Image statistic in segment}
\usage{
rasterZonalStats(segms, dem.nl, fun = max)
}
\arguments{
\item{segms}{cimg or rasterLayer object. image with segments id (e.g. from \code{\link{segmentation}})}

\item{dem.nl}{cimg or rasterLayer object. image to compute statistic from}

\item{fun}{function to compute statistis from values in each segment}
}
\value{
A cimg object or raster object with values of the statistic
}
\description{
compute zonal statistic of an image
}
\examples{
data(chmchablais3)

# median filter
chmchablais3 <- demFiltering(chmchablais3, nlFilter="Median", nlSize=3,
                             sigmap=0)$non.linear.image

# maxima detection
maxi <- maximaDetection(chmchablais3)

# segmentation
seg.maxi <- segmentation(maxi, chmchablais3)

# compute image of maximum value in each segment
max.in.segment <- rasterZonalStats(seg.maxi, chmchablais3)

# plot original image
raster::plot(chmchablais3, main="Median filter")

# plot segments and image of max value inside segments
seg.maxi[seg.maxi==0] <- NA
raster::plot(seg.maxi \%\% 8, main="Segments", col=rainbow(8))
raster::plot(max.in.segment, main="Max value in segment")
}
\seealso{
\code{\link{segmentation}}
}
