% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{std_tree_metrics}
\alias{std_tree_metrics}
\title{Computation of tree metrics}
\usage{
std_tree_metrics(x, area_ha = NA)
}
\arguments{
\item{x}{data.frame containing the following columns for each line (segmented tree): 
\code{h} (height), \code{s} (crown surface), \code{v} (crown volume), typically 
returned by \code{\link{tree_extraction}}. \code{sp} (crown surface inside region 
of interest) and \code{vp} (crown volume in region of interest) are not used 
in this function.}

\item{area_ha}{numeric. area of region of interest in ha}
}
\value{
a data.frame with one line containing the following tree metrics:
\enumerate{
\item \code{Tree_meanH}: mean height of detected tree apices (m)
\item \code{Tree_sdH}: standard deviation of heights of detected tree apices (m)
\item \code{Tree_giniH}: Gini index of heights of detected tree apices
\item \code{Tree_density}: density of detected tree apices (/ha)
\item \code{TreeInf10_density}: density of detected trees apices with h<=10 (/ha)
\item \code{TreeSup10_density}: density of detected trees apices with h>10 (/ha)
\item \code{TreeSup20_density}: density of detected trees apices with h>20 (/ha)
\item \code{TreeSup30_density}: density of detected trees apices with h>30 (/ha)
\item \code{Tree_meanCrownSurface}: mean crown surface of detected trees
\item \code{Tree_meanCrownVolume}: mean volume of detected trees
\item \code{TreeCanopy_meanH}: mean height of union of crowns of detected trees
}
}
\description{
This function computes summary statistics from a data.frame containing 
tree-level information as returned by \code{\link{tree_extraction}}.
}
\examples{
# sample 50 height values
h <- runif(50, 5, 40)
# simulate tree data.frame
trees <- data.frame(h = h, s = h, sp = h * 0.95, v = h * h * 0.6, vp = h * h * 0.55)
std_tree_metrics(trees, area_ha = 0.1)
}
\seealso{
\code{\link{tree_extraction}}
}
