% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experiments.R
\name{merge_lists}
\alias{merge_lists}
\title{Merge a list of lists into one list}
\usage{
merge_lists(list_of_lists)
}
\arguments{
\item{list_of_lists}{list of lists, each with structure 
list(source1 = c(var1, var2), source2 = c(var3, var4))
where source is a source of data as defined in a Person
object, and var1 and var2 are variables from source1, 
while var3 and var4 are variables from source2}
}
\value{
one list, with structure list(source1 = c(var1, var2), 
                                      source2 = c(var3, var4)),
        where variables from the same source have been grouped in that 
        source's sublist
}
\description{
merges list of lists specifying source and variables from each
             source into one list
}
\examples{
variables = list("fitbit_intraday" = c("steps"), 
                "fitbit_daily" = c("sleepDuration"),
                "util" = c("day_of_week", "day_type", "month"))
measures = list("fitbit_daily" = c("distance", "restingHeartRate"))
all_variables <- merge_lists(list(variables, measures))

}
