% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{iterative.bulk.gsea}
\alias{iterative.bulk.gsea}
\title{Iterative bulk gene set enrichment analysis}
\usage{
iterative.bulk.gsea(
  ...,
  set.list,
  threshold.eval = 10,
  n.rand = c(100, 1000, 10000),
  verbose = TRUE
)
}
\arguments{
\item{...}{arguments to be passed to \code{\link{bulk.gsea}}}

\item{set.list}{list of gene sets}

\item{threshold.eval}{threshold for applying additional permutations (default: 10)}

\item{n.rand}{list of number of random permutations used to assess significance (default: c(1e2,1e3,1e4))}

\item{verbose}{whether to use high verbosity level (default: TRUE)}
}
\description{
Iterative bulk gene set enrichment analysis
}
\examples{
data("org.Hs.GO2Symbol.list")  
universe <- unique(unlist(org.Hs.GO2Symbol.list))  # get universe
gs <- org.Hs.GO2Symbol.list[[1]]  # get a gene set
vals <- rnorm(length(universe), 0, 10)  # simulate values
names(vals) <- universe
vals[gs] <- rnorm(length(gs), 100, 10)  
gs.list <- org.Hs.GO2Symbol.list # get gene sets
# reduce n.rand for speed
iterative.bulk.gsea(values = vals, set.list = gs.list[1:3], mc.cores = 1, n.rand=100) 

}
