% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_generic.R
\name{lr_parse_generic}
\alias{lr_parse_generic}
\title{Generic function to parse spectra files that don't have a specific parser}
\usage{
lr_parse_generic(filename, decimal = ".", sep = NULL)
}
\arguments{
\item{filename}{Path of the file to parse}

\item{decimal}{Character to be used to identify decimal plates
(defaults to \code{.}).}

\item{sep}{Column delimiting characters to be considered in addition to the
default (which are: tab, space, and ";")}
}
\value{
A list of two elements:
\itemize{
\item a dataframe with columns "wl", "dark", "white", "scope" and "processed",
in that order
\item a list with metadata including
}
}
\description{
Generic function to parse spectra files that don't have a specific parser
}
\examples{
lr_parse_generic(system.file("testdata", "spec.csv", package = "lightr"),
                 sep = ",")
lr_parse_generic(system.file("testdata", "CRAIC_export.txt",
                             package = "lightr"))

}
