% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/play.R
\name{play}
\alias{play}
\title{Play (press) a single light or multiple lights on a board}
\usage{
play(board, row, col, matrix)
}
\arguments{
\item{board}{A \code{lightsout} board}

\item{row}{The row of the light to press. To press multiple lights, use a list
of row numbers. If a list is provided, then the \code{col} argument must also
be a list of the same length.}

\item{col}{The column of the light to press. To press multiple lights, use a list
of column numbers. If a list is provided, then the \code{row} argument must also
be a list of the same length.}

\item{matrix}{Instead of using \code{row} and \code{col}, a matrix can be used
to specify which lights to press. The matrix must have the same dimensions as
the board. Any position in the given matrix with a value of \code{1} will
result in a press of a light in the same position in the board.}
}
\value{
A new \code{lightsout} board object after the given lights are pressed.
}
\description{
In classic mode, pressing a light will toggle it and its four adjacent lights.
In variant mode, pressing a light will toggle it and all other lights in its
row and column.  Toggling a light means switching it from on to off or from
off to on.
}
\examples{
# Create a 5x5 board with all lights switched off and then press some lights

board <- empty_board(5)
board

# Press the light at (2,1)
newboard <- play(board, 2, 1)
newboard

# Press the light at (2,1) and then at (3,4)
newboard <- board \%>\% play(2, 1) \%>\% play(3, 4)
newboard

# Press both lights with one call
newboard <- play(board, c(2, 3), c(1, 4))
newboard

# Press both lights using a matrix instead of specifying rows and columns
newboard <- play(board, matrix = matrix(
                          c(0, 0, 0, 0, 0,
                            1, 0, 0, 0, 0,
                            0, 0, 0, 1, 0,
                            0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0),
                          nrow = 5, byrow = TRUE))
newboard

# Press the same lights, but this time when the game mode is not classic,
# and the whole row/column get toggled
empty_board(5, classic = FALSE) \%>\% play(2, 1)
empty_board(5, classic = FALSE) \%>\% play(c(2, 3), c(1, 4))
}
\seealso{
\code{\link[lightsout]{solve_board}}
\code{\link[lightsout]{empty_board}}
\code{\link[lightsout]{new_board}}
\code{\link[lightsout]{random_board}}
}

