% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\docType{data}
\name{opts}
\alias{opts}
\alias{set}
\alias{get}
\alias{reset}
\title{Options for the limonaid package}
\format{
An object of class \code{list} of length 4.
}
\usage{
opts
}
\description{
The \code{limonaid::opts} object contains three functions to set, get, and reset
options used by the escalc package. Use \code{limonaid::opts$set} to set options,
\code{limonaid::opts$get} to get options, or \code{limonaid::opts$reset} to reset specific or
all options to their default values.
}
\details{
It is normally not necessary to get or set \code{limonaid} options.

The following arguments can be passed:

\describe{
\item{...}{For \code{limonaid::opts$set}, the dots can be used to specify the options
to set, in the format \code{option = value}, for example,
\code{silent = FALSE}. For
\code{limonaid::opts$reset}, a list of options to be reset can be passed.}
\item{option}{For \code{limonaid::opts$set}, the name of the option to set.}
\item{default}{For \code{limonaid::opts$get}, the default value to return if the
option has not been manually specified.}
}

The following options can be set:

\describe{

\item{silent}{Whether to be chatty or silent.}

\item{encoding}{The encoding to use when writing files.}

\item{preventOverwriting}{The name of the column
with the missing values.}

}
}
\examples{
### Get the default silent setting
limonaid::opts$get('silent');

### Set it to FALSE
limonaid::opts$set(silent = FALSE);

### Check that it worked
limonaid::opts$get('silent');

### Reset this option to its default value
limonaid::opts$reset('silent');

### Check that the reset worked, too
limonaid::opts$get('silent');

}
\keyword{datasets}
