% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_next_step.R
\name{what_combo}
\alias{what_combo}
\title{what_combo}
\usage{
what_combo(
  model = NULL,
  trans_df = NULL,
  data = NULL,
  dv = NULL,
  r2_diff = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{model}{Model object}

\item{trans_df}{\code{data.frame} containing the transformations, variables and parameter values}

\item{data}{\code{data.frame} containing data from analysis}

\item{dv}{string specifying the dependent variable name}

\item{r2_diff}{A boolean to determine whether to add a column to compare new and original model R2}

\item{verbose}{A boolean to specify whether to print warnings}
}
\value{
list of two \code{data.frame} mapping variables' transformations to the respective model's statistics.
}
\description{
run models across combinations of transformations and variables
}
\details{
Run a separate model for each combination of transformations specified.
The combinations are defined by the possible transformation parameters specified in the trans_df.
Then, for each model run, return that model's fit and the variables' statistics.
}
\examples{

# using a model object
data = read_xcsv("https://raw.githubusercontent.com/paladinic/data/main/ecomm_data.csv")
dv = 'ecommerce'
ivs = c('christmas','black.friday')

model = run_model(data = data,dv = dv,ivs = ivs)

trans_df = data.frame(
  name = c('diminish', 'decay', 'hill', 'exp'),
  func = c(
    'linea::diminish(x,a)',
    'linea::decay(x,a)',
    "linea::hill_function(x,a,b,c)",
    '(x^a)'
  ),
  order = 1:4
) \%>\%
  dplyr::mutate(offline_media = dplyr::if_else(condition = name == 'hill',
                                               '(1,50),(1),(1,100)',
                                               '')) \%>\%
  dplyr::mutate(online_media = dplyr::if_else(condition = name == 'decay',
                                              '.1,.7 ',
                                              '')) \%>\%
  dplyr::mutate(promo = '')

what_combo(model = model,trans_df = trans_df)

#using the trans_df, data, and dv
what_combo(trans_df = trans_df, data = data, dv = dv)
}
