% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corbetw2mat.R
\name{corbetw2mat}
\alias{corbetw2mat}
\title{Calculate correlations between columns of two matrices}
\usage{
corbetw2mat(
  x,
  y,
  what = c("paired", "bestright", "bestpairs", "all"),
  corthresh = 0.9
)
}
\arguments{
\item{x}{A numeric matrix.}

\item{y}{A numeric matrix with the same number of rows as \code{x}.}

\item{what}{Indicates which correlations to calculate and return.  See
value, below.}

\item{corthresh}{Threshold on correlations if \code{what="bestpairs"}.}
}
\value{
If \code{what="paired"}, the return value is a vector of
correlations, between columns of \code{x} and the corresponding column of
\code{y}.  \code{x} and \code{y} must have the same number of columns.

If \code{what="bestright"}, we return a data frame of size \code{ncol(x)} by
\code{3}, with the \eqn{i}th row being the maximum correlation between
column \eqn{i} of \code{x} and a column of \code{y}, and then the
\code{y}-column index and \code{y}-column name with that correlation.  (In
case of ties, we give the first one.)

If \code{what="bestpairs"}, we return a data frame with five columns,
containing all pairs of columns (with one in \code{x} and one in \code{y})
with correlation \eqn{\ge} \code{corthresh}.  Each row corresponds to a
column pair, and contains the correlation and then the \code{x}- and
\code{y}-column indices followed by the \code{x}- and \code{y}-column names.

If \code{what="all"}, the output is a matrix of size \code{ncol(x)} by
\code{ncol(y)}, with all correlations between columns of \code{x} and
columns of \code{y}.
}
\description{
For matrices x and y, calculate the correlation between columns of x and
columns of y.
}
\details{
Missing values (\code{NA}) are ignored, and we calculate the correlation
using all complete pairs, as in \code{\link[stats:cor]{stats::cor()}} with
\code{use="pairwise.complete.obs"}.
}
\examples{

data(expr1, expr2)
\dontshow{expr1 <- expr1[,1:100]
expr2 <- expr2[,1:100]}

# correlations with paired columns
r <- corbetw2mat(expr1, expr2)
# top 10, by absolute value
r[order(abs(r), decreasing=TRUE)[1:10]]

# all pairs of columns with correlation >= 0.8
r_allpairs <- corbetw2mat(expr1, expr2, what="bestpairs", corthresh=0.6)

# for each column in left matrix, most-correlated column in right matrix
r_bestright <- corbetw2mat(expr1, expr2, what="bestright")

}
\seealso{
\code{\link[=distee]{distee()}}, \code{\link[=findCommonID]{findCommonID()}}
}
\author{
Karl W Broman, \email{broman@wisc.edu}
}
\keyword{array}
\keyword{multivariate}
\keyword{univar}
