% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eliminate.R
\name{eliminate}
\alias{eliminate}
\title{Eliminate a variable from a set of edit rules}
\usage{
eliminate(A, b, neq = nrow(A), nleq = 0, variable, H = NULL, h = 0,
  eps = 1e-08)
}
\arguments{
\item{A}{\code{[numeric]} Matrix}

\item{b}{\code{[numeric]} vector}

\item{neq}{[\code{numeric}] The first \code{neq} rows in \code{A} and
\code{b} are treated as linear equalities.}

\item{nleq}{[\code{numeric}] The \code{nleq} rows after \code{neq} are treated as
inequations of the form \code{a.x<=b}. All remaining rows are treated as strict inequations
of the form \code{a.x<b}.}

\item{variable}{\code{[numeric|logical|character]} Index in columns of \code{A}, representing the variable to eliminate.}

\item{H}{\code{[numeric]} (optional) Matrix indicating how linear inequalities have been derived.}

\item{h}{\code{[numeric]} (optional) number indicating how many variables have been eliminated from the original system
using Fourier-Motzkin elimination.}

\item{eps}{\code{[numeric]} Coefficients with absolute value  \code{<= eps} are treated as zero.}
}
\value{
A \code{list} with the folowing components
\itemize{
  \item{\code{A}: the \code{A} corresponding to the system with variables eliminated.}
  \item{\code{b}: the constant vector corresponding to the resulting system}
  \item{\code{neq}: the number of equations}
  \item{\code{H}: The memory matrix storing how each row was derived}
  \item{\code{h}: The number of variables eliminated from the original system.}
}
}
\description{
Eliminating a variable amounts to deriving all (non-redundant) linear
(in)equations not containing that variable. Geometrically, it can be interpreted as
a projection of the solution space (vectors satisfying all equations) along the
eliminated variable's axis.
}
\section{Details}{

For equalities Gaussian elimination is applied. If inequalities are involved,
Fourier-Motzkin elimination is used. In principle, FM-elimination can
generate a large number of redundant inequations, especially when applied
recursively. Redundancies can be recognized by recording how new inequations
have been derived from the original set. This is stored in the \code{H} matrix
when multiple variables are to be eliminated (Kohler, 1967).
}

\examples{

# Example from Williams (1986)
A <- matrix(c(
   4, -5, -3,  1,
  -1,  1, -1,  0,
   1,  1,  2,  0,
  -1,  0,  0,  0,
   0, -1,  0,  0,
   0,  0, -1,  0),byrow=TRUE,nrow=6) 
b <- c(0,2,3,0,0,0)
L <- eliminate(A=A, b=b, neq=0, nleq=6, variable=1)


}
\references{
D.A. Kohler (1967) Projections of convex polyhedral sets, Operational Research
Center Report , ORC 67-29, University of California, Berkely.

H.P. Williams (1986) Fourier's method of linear programming and its dual. American
Mathematical Monthly 93, pp 681-695.
}
