% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/liquidSVM.R
\name{predict.liquidSVM}
\alias{predict.liquidSVM}
\alias{predict}
\title{Predicts labels of new data using the selected SVM.}
\usage{
\method{predict}{liquidSVM}(object, newdata, ...)
}
\arguments{
\item{object}{the SVM model as returned by \code{\link{init.liquidSVM}}}

\item{newdata}{data frame of features to predict.
If it has all the explanatory variables of \code{formula}, then the respective subset is taken.}

\item{...}{other parameters passed to \code{\link{test.liquidSVM}}}
}
\value{
the predicted values of test
}
\description{
After training and selection the SVM provides means to compute predictions
for new input features.
If you have also labels consider using \code{\link{test.liquidSVM}}.
}
\details{
In the multi-result learning scenarios this returns all the predictions
corresponding to the different quantiles, expectiles, etc.
For multi-class classification, if the model was setup with \code{predict.prob=TRUE}
Then this will return only the probability columns and not the prediction.
}
\examples{
\dontrun{
## Multiclass classification
modelIris <- svm(Species ~ ., iris)
y <- predict(modelIris, iris)

## Least Squares
modelTrees <- svm(Height ~ Girth + Volume, trees)
y <- predict(modelTrees, trees)
plot(trees$Height, y)
}
}
\seealso{
\code{\link{init.liquidSVM}} and \code{\link{test.liquidSVM}}
}
