% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dim2.R
\name{array2}
\alias{array2}
\alias{dim2<-}
\alias{set_dim2}
\title{Make or reshape an array with C-style (row-major) semantics}
\usage{
array2(data, dim = length(data), dimnames = NULL)

dim2(x) <- value

set_dim2(...)
}
\arguments{
\item{data}{what to fill the array with}

\item{dim}{numeric vector of dimensions}

\item{dimnames}{a list of dimnames, must be the same length as \code{dims}}

\item{x}{object to set dimensions on (array or atomic vector)}

\item{value}{a numeric (integerish) vector of new dimensions}

\item{...}{passed on to \code{set_dim()}}
}
\description{
These functions reshape or make an array using C-style, row-major semantics.
The returned array is still R's native F-style, (meaning, the underlying
vector has been reordered).
}
\details{
Other than the C-style semantics, these functions behave identically to their
counterparts (\code{array2()} behaves identically to \code{array()}, \code{`dim2<-`()}
to \code{`dim<-`()}). \code{set_dim2()} is just a wrapper around \code{set_dim(..., order = "C")}.

See examples for a drop-in pure R replacement to \code{reticulate::array_reshape()}
}
\examples{
array(1:4, c(2,2))
array2(1:4, c(2,2))

# for a drop-in replacement to reticulate::array_reshape
array_reshape <- listarrays:::array_reshape
array_reshape(1:4, c(2,2))
}
