% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_bind.R
\name{list_bind}
\alias{list_bind}
\title{Bind list elements together.}
\usage{
list_bind(in_list, ..., what = "rows", name = NULL)
}
\arguments{
\item{in_list}{The list to work on.}

\item{...}{A selection of elements to bind together.}

\item{what}{Either 'rows' or 'cols'.}

\item{name}{Optional name for the resulting element.}
}
\value{
A list with the selected elements bound together as specified.
}
\description{
Bind list elements together.
}
\details{
The element to bind together must be compatible in the dimension you
want to bind them together, if not there will either be an error or an
unexpected result.

The `what` parameter specifies whether to call `rbind` or `cbind` on the
selected elements.

Using `name` you can optionally specify a new name for the result. It
will be in the position of the first selected element, while the other
selected elements will be removed from the input list.
}
\examples{
dfl <- list(data.frame(idx = 1:20, y = rnorm(20)),
            data.frame(idx = 21:40, y = rnorm(20)),
            data.frame(idx = 41:60, y = rnorm(20)))
list_bind(dfl, 1, 2, 3)
}
