% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_extract.R
\name{list_extract}
\alias{list_extract}
\title{Extract an element from a list using tidy selection.}
\usage{
list_extract(in_list, ...)
}
\arguments{
\item{in_list}{The list to extract an element from.}

\item{...}{A selection of what to extract. Must be a single element.}
}
\value{
The selected list element.
}
\description{
This is pretty much an equivalent of calling `[[` on a list, but allows
for cleaner use inside pipes.
}
\examples{
my_list <- list(rnorm(20), data.frame(x = 1:10, y = rnorm(10)), letters[1:5])
list_extract(my_list, 3)
}
