% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{list_duplicates}
\alias{list_duplicates}
\alias{list_duplicates.character}
\alias{list_duplicates.tbl}
\alias{list_duplicates.data.frame}
\title{List Duplicates}
\usage{
list_duplicates(x, ...)

\method{list_duplicates}{character}(x, ...)

\method{list_duplicates}{tbl}(x, ...)

\method{list_duplicates}{data.frame}(x, ...)
}
\arguments{
\item{x}{object of class \code{\link{character}}, \code{\link{tibble}} 
or \code{\link{data.frame}})}

\item{\dots}{further arguments passed to or from other methods.}
}
\value{
\code{\link{list}} of row numbers with duplicates
}
\description{
Lists all duplicates as a list of tuples.
}
\section{Methods (by class)}{
\itemize{
\item \code{character}: list duplicates for a \code{\link{character}} vector.

\item \code{tbl}: lists duplicates for a \code{\link{tibble}}.

\item \code{data.frame}: lists duplicates for a \code{\link{data.frame}}.
}}

\examples{
list_duplicates(c("a", "b", "c")) # list()
list_duplicates(c("a", "b", "a", "c")) # list(c(1, 3))
}
