% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explore.R
\name{add_predictions2}
\alias{add_predictions2}
\title{Add black box predictions to generated dataset}
\usage{
add_predictions2(to_explain, black_box_model, data = NULL,
  predict_fun = predict, hyperparams = list(), ...)
}
\arguments{
\item{to_explain}{List return by sample_locally function.}

\item{black_box_model}{String with mlr signature of a learner or a model with predict interface.}

\item{data}{Original data frame used to generate new dataset. 
Need not be provided when a trained model is passed in 
black_box_model argument.}

\item{predict_fun}{Either a "predict" function that returns a vector of the
same type as response or custom function that takes a model as a first argument,
and data used to calculate predictions as a second argument
and returns a vector of the same type as respone.
Will be used only if a model object was provided in the black_box argument.}

\item{hyperparams}{Optional list of (hyper)parameters to be passed to mlr::makeLearner.}

\item{...}{Additional parameters to be passed to predict function.}
}
\value{
list consisting of
\item{data}{Dataset generated by sample_locally function with response variable.}
\item{target}{Name of the response variable.}
\item{model}{Black box model which is being explained.}
\item{explained_instance}{Instance that is being explained.}
}
\description{
Add black box predictions to generated dataset
}
\examples{
\dontrun{
local_exploration1 <- add_predictions(wine, dataset_for_local_exploration,
                                      black_box_model = "regr.svm")
# Pass trained model to the function.
svm_model <- svm(quality ~., data = wine)
local_exploration2 <- add_predictions(wine, dataset_for_local_exploration,
                                      black_box_model = svm_model)
}

}
