% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dllogistic.R, R/pllogistic.R, R/qllogistic.R,
%   R/rllogistic.R
\name{llogistic}
\alias{llogistic}
\alias{dllogistic}
\alias{llogistic}
\alias{pllogistic}
\alias{llogistic}
\alias{qllogistic}
\alias{llogistic}
\alias{rllogistic}
\title{The L-Logistic Distribution}
\source{
The L-Losgistic distribution was introduced by Tadikamalla and Johnson (1982), which refer to this distribution as Logit-Logistic
distribution. Here, we have a new parameterization of the Logit-Logistic with the median as a parameter.

 \eqn{f(x)=b (1 - m)^b m^b (x(1 - x))^(b - 1)/((1 - m)^b x^b + m^b (1 - x)^b)^2},

 for 0< x < 1.
}
\usage{
dllogistic(x, m, b, log = FALSE)

pllogistic(q, m, b, lower.tail = TRUE, log.p = FALSE)

qllogistic(p, m, b, lower.tail = TRUE, log.p = FALSE)

rllogistic(n, m, b)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{m, b}{parameters of the L-Logistic distribution.
The parameter m lies in the interval (0,1) and b is positive.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \leq x ]}, otherwise, P[X > x].}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\value{
dllogistic(x,m,b) gives the density function,
 rllogistic(n,m,b) gives n random variates and qllogistic(p,m,b) gives the quantile.
}
\description{
Density, distribution function,
quantile function and random generation for
the L-Logistic distribution with parameters m and b.  A parameterization of the density function of this distribution can be seen in Tadikamalla, P. R. and Johnson, N. L (1982) <DOI:https://doi.org/10.1093/biomet/69.2.461>.
}
\details{
The llogistic distribution has density
}
\examples{
dllogistic(0.3, 0.5, 2)
pllogistic(0.7, 0.5, 2)
qllogistic(0.2, 0.5, 2)
rllogistic(10, 0.5, 2)
}
\references{
Paz, R.F., Balakrishnan, N and  Bazán, Jorge L. (2016). L-Logistic Distribution: Properties, Inference and an Application to Study Poverty and Inequality  in Brazil.
São Carlos: Universidade Federal de São Carlos. Tecnical-Scientific Report No. 261, Teory and Method. Sponsored by the Department of Statistical. <URL:\url{http://www.pipges.ufscar.br/publicacoes/relatorios-tecnicos/arquivos-1/rt261.pdf}>.

TADIKAMALLA, P. R.; JOHNSON, N. L. (1982). Systems of frequency curves generated by transformations
of logistic variables. Biometrika, v. 69, n. 2, p. 461.
}
