% $Id: getGroups.gls.Rd,v 1.2 1998/04/06 21:35:16 pinheiro Exp $
\name{getGroups.gls}
\title{Extract gls Object Groups}
\usage{
getGroups(object)
}
\alias{getGroups.gls}
\arguments{
 \item{object}{an object inheriting from class \code{gls}, representing
   a generalized least squares fitted linear model.}
}
\description{
  If present, the grouping factor associated to the correlation
  structure for the linear model represented by \code{object} is extracted. 
}
\value{
  if the linear model represented by \code{object} incorporates a
  correlation structure and the corresponding \code{corStruct} object
  has a grouping factor, a vector with the group values is returned;
  else, \code{NULL} is returned.
}

\author{Jose Pinheiro and Douglas Bates}

\seealso{\code{\link{gls}}, \code{\link{corClasses}}}

\examples{
library(lme)
data(Ovary)
fm1 <- gls(follicles ~ sin(2*pi*Time) + cos(2*pi*Time), Ovary,
           correlation = corAR1(form = ~ 1 | Mare))
getGroups(fm1)
}
\keyword{models}
