% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmmen.R
\name{lmmen}
\alias{lmmen}
\title{linear mixed model Elastic Net}
\usage{
lmmen(data, init.beta, frac, eps = 10^(-4), verbose = FALSE)
}
\arguments{
\item{data}{matrix, data}

\item{init.beta}{numeric, initial values for fixed effects coefficients}

\item{frac}{numeric, penalty levels for fixed and random effects expressed in ratios. 
c(L1.fixed,L2.fixed,L1.random,L2.random)}

\item{eps}{numeric, tolerance level to pass to solve.QP, Default: 10^(-4)}

\item{verbose}{boolean, show output during optimization Default: FALSE}
}
\value{
lmmen fit object including

fixed: estimated fixed effects coefficients

stddev: estimated random effects covariance matrix standard deviations 

sigma.2: standard error of the model residual effect

lambda: estimated lower triangle of \eqn{\Lambda} (correlation of random effects)

Mean.est: model prediction \eqn{X^{t}\beta}

loglike: log likelihood

df: degrees of freedom

BIC: Minimum BIC penalty value

frac: ratio placed on the penalties corresponding to BIC

Gamma.Mat.RE: estimated \eqn{\Gamma} 

Cov.Mat.RE: estimated random effect covariance matrix

Corr.Mat.RE: estimate random effects correlation matrix

solveQP: output of the call to solveQP corresponding to min BIC
}
\description{
Regularize a linear mixed model with the linear mixed model Elastic Net penalty.
}
\details{
\eqn{y_i=x^{t}_{ij}\beta+z^{t}_{ij}b_i+\epsilon_i,}

\eqn{\epsilon_i\sim N(0,\sigma^2I_{n_i})}

The lmmen function solves for the folloing problem. 

\eqn{Q(\phi|y,b)=||y-Z\Lambda\Gamma b-X\beta||^2+\tilde{P}(\beta,d)}
     
\eqn{\tilde{P}(\beta,d)=}

\eqn{\lambda_2^f\sum\limits_{i\in P}\beta_i^2+\lambda_2^r\sum\limits_{j\in Q}d_j^2+}

\eqn{\lambda_1^f\sum\limits_{i \in P}|\beta_i|+\lambda_1^r\sum\limits_{j \in Q}|d_j|}

 Where \eqn{\tilde{P}} and \eqn{Q(\phi)} denote the penalty applied to the likelihood 
 and the penalized log-likelihood. 
 
 When the final model is not a mixed effects model, but either a fixed effects or random 
 effects model then the original form of the Elastic Net penalty is applied.
}
\examples{
 dat <- initialize_example(n.i = 5,n = 30,q=4,seed=1)
 init <- init.beta(dat,method='glmnet')
 lmmen(data=dat,init.beta=init,frac=c(0.8,1,1,1))
}
\references{
\href{https://github.com/yonicd/lmmen/tree/master/references}{Prepublished version of the lmmen paper.}
}
\seealso{
\code{\link[quadprog]{solve.QP}}
}
