% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_carga_datos_utils.R
\name{carga.datos}
\alias{carga.datos}
\title{Load data from text file.}
\usage{
carga.datos(
  nombre.filas = TRUE,
  ruta = NULL,
  separador = ";",
  sep.decimal = ",",
  encabezado = TRUE,
  deleteNA = TRUE,
  preview = FALSE
)
}
\arguments{
\item{nombre.filas}{a logical value indicating whether the file contains the names of the rows as its first column.}

\item{ruta}{the name of the file which the data are to be read from.}

\item{separador}{the field separator character.}

\item{sep.decimal}{the character used in the file for decimal points.}

\item{encabezado}{a logical value indicating whether the file contains the names of the variables as its first line.}

\item{deleteNA}{a logical value indicating if rows with NA should be removed.}

\item{preview}{a logical value indicating if only load the first 10 rows.}
}
\value{
A data.frame object with the information of a file.
}
\description{
Load data from text file.
}
\examples{
tf <- tempfile()
write.table(iris, tf, sep = ";", dec = ",", row.names = FALSE)
carga.datos(ruta = tf, nombre.filas = FALSE, preview = TRUE)

}
\author{
Diego Jimenez <diego.jimenez@promidat.com>
}
