\name{crita}
\alias{crit<-}
\title{
Substitute critical values on ``locfit'' object.
}
\usage{
crit(fit) <- crit(fit, cov=0.95)
}
\arguments{
\item{fit}{\code{locfit} object.}
}
\value{
  Critical value object generated by
  \code{\link{crit}} or \code{\link{kappa0}}.
}
\description{
  Every \code{locfit} object contains a critical value object to be used in
  computing and ploting confidence intervals. By default, a 95\% pointwise
  confidence level is used.  To change the confidence level, the critical
  value object must be substituted using \code{\link{crit}} and
  \code{\link{crit<-}}.
}
%\value{
%  Critical value object.
%}
\seealso{
\code{\link{locfit}}, \code{\link{plot.locfit}},
\code{\link{kappa0}}, \code{\link{crit}}.
}
\examples{
# compute and plot 99\% confidence intervals, with local variance estimate.
data(ethanol)
fit <- locfit(NOx~E,data=ethanol)
crit(fit) <- crit(fit,cov=0.99)
plot(fit,band="local")

# compute and plot 99\% simultaneous bands
crit(fit) <- kappa0(NOx~E,data=ethanol,cov=0.99)
plot(fit, band="local")
}
\keyword{smooth}
% Converted by Sd2Rd version 0.2-a5.
