% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edland.linear.power.R
\name{edland.linear.power}
\alias{edland.linear.power}
\title{Linear mixed model sample size calculations.}
\usage{
edland.linear.power(
  n = NULL,
  delta = NULL,
  power = NULL,
  t = NULL,
  lambda = 1,
  sig2.int = 0,
  sig2.s = NULL,
  sig.b0b1 = 0,
  sig2.e = NULL,
  sig2.int_2 = NULL,
  sig2.s_2 = NULL,
  sig.b0b1_2 = NULL,
  sig2.e_2 = NULL,
  sig.level = 0.05,
  p = NULL,
  p_2 = NULL,
  alternative = c("two.sided", "one.sided"),
  tol = NULL
)
}
\arguments{
\item{n}{sample size, group 1}

\item{delta}{group difference in fixed effect slopes}

\item{power}{power}

\item{t}{the observation times}

\item{lambda}{allocation ratio (= (sample size group 1)/(sample size group 2)}

\item{sig2.int}{variance of random intercepts, group 1}

\item{sig2.s}{variance of random slopes, group 1}

\item{sig.b0b1}{covariance of random slopes and intercepts,group 1}

\item{sig2.e}{residual variance, group 1}

\item{sig2.int_2}{variance of random intercepts, group 2 (defaults to \code{sig2.int})}

\item{sig2.s_2}{variance of random slopes, group 2 (defaults to \code{sig2.s})}

\item{sig.b0b1_2}{covariance of random slopes and intercepts, group 2 (defaults to \code{sig.b0b1})}

\item{sig2.e_2}{residual variance, group 2 (defaults to \code{sig2.e})}

\item{sig.level}{type one error}

\item{p}{proportion vector for group 1, if i indexes visits, \code{p[i]} = the proportion whose last visit was at visit \code{i} (\code{p} sums to \code{1})}

\item{p_2}{proportion vector for group 2 (defaults to \code{p})}

\item{alternative}{one- or two-sided test}

\item{tol}{not used (no root finding used in this implementation).}
}
\value{
One of the number of subject required per arm, the \code{power}, or detectible effect size
given \code{sig.level} and the other parameter estimates.
}
\description{
This function performs sample size calculations for the linear mixed model
with random intercepts and slopes when used to test for differences in fixed
effects slope between groups. Input parameters are random effect variance
and residual error variance as estimated by a REML fit to representative
pilot data or data from a representative prior clinical trial or cohort
study.
}
\details{
Default settings perform sample size / power / effect size calculations assuming
equal covariance of repeated measures in the 2 groups, equal residual error
variance across groups, equal allocation to groups, and assuming no study subject
attrition.  Specifically, variance parameters required for default settings
are \code{sig2.s}, the variance of random slopes, and \code{sig2.e}, the residual error
variance, both either known or estimated from a mixed model fit by REML
to prior data.

This function will also provide sample size estimates for linear mixed
models with random intercept only by setting \code{sig2.s = 0}  (although,
this is not generally recommended).

This function was generalized April 2020. The function is back compatible,
although the order of arguments has changed. The new function accommodates
different variance parameters across groups, unequal allocation across groups, and
study subject attrition (loss to followup), which may also vary across groups.
\itemize{
\item Unequal allocation is accommodated by the parameter \code{lambda}, where
\code{lambda} = (sample size group 1)/(sample size group 2). \code{lambda} defaults
to one (equal allocation).
\item Study subject attrition is accommodated by the parameter '\code{p}', where
\code{p} is a vector of proportions.  If \code{i} indexes successive study visits,
\code{p[i]} = the proportion whose last visit is at visit \code{i}. \code{p} sums to 1. \code{p}
defaults to the case of no study subject attrition (everyone completes
all visits).
\item differential study subject attrition is accommodated by the parameter \code{p_2}.
\code{p_2} is analogous to \code{p}, but for group 2. \code{p_2} defaults to \code{p} (equal pattern
of study subject attrition across groups).
\item Note that when there is study subject attrition, sample size / power
calculations are also a function of the variance of random intercepts and
the covariance of random intercepts and slopes.  When \code{p} and/or \code{p_2} are
specified, \code{edland.linear.power} requires specification of these parameters.
(These are part of the standard output of lmer and other software fitting
REML models.)  These parameters are specified by \code{sig2.int} and \code{sig.b0b1} (group 1),
and \code{sig2.int_2} and \code{sigb0b1_2} (group 2).
\item different variance parameters across groups is accommodated by the variance
arguments \code{sig2.int_2}, \code{sig.b0b1_2}, \code{sig2.s}_2 and \code{sig2.e_2}, analogous to the
the corresponding arguments within group 1.  These values default to
to the corresponding group 1 variables (equal variance across groups).
\item The parameter \code{t} is the design vector. For example, a one year trial with
observations every three months would specify \code{t = c(0, .25, .5, .75, 1)}.
}
}
\examples{

\dontrun{
browseVignettes(package = "longpower")
}
# An Alzheimer's Disease example using ADAS-cog pilot estimates
t = seq(0,1.5,0.25)
edland.linear.power(delta=1.5, t=t, sig2.s = 24, sig2.e = 10, sig.level=0.05, power = 0.80)

}
\references{
Ard and Edland, S.D. (2011) Power calculations for clinical trials in Alzheimer's disease.
\emph{Journal of Alzheimer's Disease.} 21:369-377.
}
\seealso{
\code{\link{lmmpower}}, \code{\link{diggle.linear.power}}, \code{\link{liu.liang.linear.power}}
}
\author{
Michael C. Donohue, Steven D. Edland
}
\keyword{effects}
\keyword{mixed}
\keyword{power}
\keyword{random}
\keyword{sample}
\keyword{size}
