% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psis_approximate_posterior.R
\name{psis_approximate_posterior}
\alias{psis_approximate_posterior}
\title{Diagnostics for Laplace and ADVI approximations and Laplace-loo and ADVI-loo}
\usage{
psis_approximate_posterior(
  log_p = NULL,
  log_g = NULL,
  log_liks = NULL,
  cores,
  save_psis,
  ...,
  log_q = NULL
)
}
\arguments{
\item{log_p}{The log-posterior (target) evaluated at S samples from the
proposal distribution (g). A vector of length S.}

\item{log_g}{The log-density (proposal) evaluated at S samples from the
proposal distribution (g). A vector of length S.}

\item{log_liks}{A log-likelihood matrix of size S * N, where N is the number
of observations and S is the number of samples from q. See
\code{\link[=loo.matrix]{loo.matrix()}} for details. Default is \code{NULL}. Then only the
posterior is evaluated using the k_hat diagnostic.}

\item{cores}{The number of cores to use for parallelization. This defaults to
the option \code{mc.cores} which can be set for an entire R session by
\code{options(mc.cores = NUMBER)}. The old option \code{loo.cores} is now
deprecated but will be given precedence over \code{mc.cores} until
\code{loo.cores} is removed in a future release. \strong{As of version
2.0.0 the default is now 1 core if \code{mc.cores} is not set}, but we
recommend using as many (or close to as many) cores as possible.
\itemize{
\item Note for Windows 10 users: it is \strong{strongly}
\href{https://github.com/stan-dev/loo/issues/94}{recommended} to avoid using
the \code{.Rprofile} file to set \code{mc.cores} (using the \code{cores} argument or
setting \code{mc.cores} interactively or in a script is fine).
}}

\item{save_psis}{Should the \code{psis} object created internally by \code{loo()} be
saved in the returned object? The \code{loo()} function calls \code{\link[=psis]{psis()}}
internally but by default discards the (potentially large) \code{psis} object
after using it to compute the LOO-CV summaries. Setting \code{save_psis=TRUE}
will add a \code{psis_object} component to the list returned by \code{loo}.
This is useful if you plan to use the \code{\link[=E_loo]{E_loo()}} function to compute
weighted expectations after running \code{loo}. Several functions in the
\pkg{bayesplot} package also accept \code{psis} objects.}

\item{log_q}{Deprecated argument name (the same as log_g).}
}
\value{
If log likelihoods are supplied, the function returns a \code{"loo"} object,
otherwise the function returns a \code{"psis"} object.
}
\description{
Diagnostics for Laplace and ADVI approximations and Laplace-loo and ADVI-loo
}
\references{
Vehtari, A., Gelman, A., and Gabry, J. (2017). Practical Bayesian model
evaluation using leave-one-out cross-validation and WAIC.
\emph{Statistics and Computing}. 27(5), 1413--1432. doi:10.1007/s11222-016-9696-4
(\href{https://link.springer.com/article/10.1007/s11222-016-9696-4}{journal version},
\href{https://arxiv.org/abs/1507.04544}{preprint arXiv:1507.04544}).

Vehtari, A., Simpson, D., Gelman, A., Yao, Y., and Gabry, J. (2022).
Pareto smoothed importance sampling.
\href{https://arxiv.org/abs/1507.02646}{preprint arXiv:1507.02646}
}
\seealso{
\code{\link[=loo]{loo()}} and \code{\link[=psis]{psis()}}
}
\keyword{internal}
