% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_multi.R
\name{scale_multi}
\alias{scale_multi}
\title{Position scales for continuous data (x, y & z)}
\usage{
scale_multi(trans = scaleBox(center = TRUE), ...)
}
\arguments{
\item{trans}{For continuous scales, the name of a transformation object or the object itself.
Built-in transformations include "asn", "atanh", "boxcox", "date", "exp", "hms", "identity", "log", "log10", "log1p",
"log2", "logit", "modulus", "probability", "probit", "pseudo_log", "reciprocal", "reverse", "sqrt" and "time".
A transformation object bundles together a transform, its inverse, and methods for generating breaks and labels.
Transformation objects are defined in the scales package, and are called  <name>_trans (e.g., \code{scales::boxcox_trans()}).
You can create your own transformation with \code{scales::trans_new()}.}

\item{...}{Other arguments passed on to \code{scale_(x|y)_continuous()}. To set the position scales,
three scales (x, y, z) has to be set simultaneously.}
}
\value{
a list of the \code{ggproto} objects
}
\description{
Scaling the coordinates for 3D visualization
}
\details{
In 3D rotation, different scales of variables x, y and z may cause an issue that the points appear to be
off the window even with a minor tweak. Additionally, if one variable is in a large scale,
the shape of the 3D plot may be dominated. Setting \code{scale_multi} can ensure the scales in the same measurement, as
we rotate the plot, most points will stay inside the current view.
}
\examples{
if(interactive()) {

dsamp <- dplyr::sample_n(diamonds, 100)

\dontrun{
# press `R`, then rotate with a minor tweak,
# Issues:
#   1: the points are off the window
#   2: Always in a line shape
l_ggplot(dsamp, aes(x = carat, y = price,
                    z = depth, colour = color)) +
  geom_point()}

# set scales
l_ggplot(dsamp, aes(x = carat, y  =price,
                    z = depth, colour = color)) +
  geom_point() +
  scale_multi()

# customized `trans`
logp1_base10_trans <- scales::trans_new(
  name = "logp",
  trans = function(x) log(x + 1, base = 10),
  inverse = function(x) 10**x - 1,
  breaks = scales::log_breaks())

l_ggplot(dsamp, aes(x = carat, y = price,
                    z = depth, colour = color)) +
  geom_point() +
  scale_multi(trans = logp1_base10_trans)
}
}
