% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_layer.R
\name{l_layer_isVisible}
\alias{l_layer_isVisible}
\title{Return visibility flag of layer}
\usage{
l_layer_isVisible(widget, layer)
}
\arguments{
\item{widget}{widget path or layer object of class \code{'l_layer'}}

\item{layer}{layer id. If the widget argument is of class \code{'l_layer'}
then the layer argument is not used}
}
\value{
\code{TRUE} or \code{FALSE} depending whether the layer is visible or
  not.
}
\description{
Hidden or invisible layers are not rendered. This function
  queries whether a layer is visible/rendered or not.
}
\details{
Visibile layers are rendered, invisible ones are not. If any
  ancestor of a layer is set to be invisible then the layer is not rendered
  either. The layer visibility flag can be checked with
  \code{\link{l_layer_isVisible}} and the actual visibility (i.e. are all the
  ancesters visibile too) can be checked with
  \code{\link{l_layer_layerVisibility}}.

  Note that layer visibility is not a state of the layer itself,
  instead is information that is part of the layer collection (i.e. its
  parent widget).
}
\examples{
if(interactive()){

p <- l_plot()
l <- l_layer_rectangle(p, x=0:1, y=0:1)
l_layer_isVisible(p, l)
l_layer_hide(p, l)
l_layer_isVisible(p, l)

}
}
\seealso{
\code{\link{l_layer}}, \code{\link{l_layer_show}},
  \code{\link{l_layer_hide}}, \code{\link{l_layer_layerVisibility}},
  \code{\link{l_layer_groupVisibility}}
}
