% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_plot_ts.R
\name{l_plot_ts}
\alias{l_plot_ts}
\title{Draw a decomposed time series loon plot}
\usage{
l_plot_ts(
  x,
  color = l_getOption("color"),
  size = l_getOption("size"),
  lcolor = l_getOption("color"),
  linewidth = l_getOption("linewidth"),
  xlabel = NULL,
  ylabel = NULL,
  title = NULL,
  tk_title = NULL,
  linkingGroup = NULL,
  showScales = TRUE,
  showGuides = TRUE,
  showLabels = TRUE,
  ...
)
}
\arguments{
\item{x}{Either an \code{stl} object or a \code{decomposed.ts} object.}

\item{color}{points colour of all time series.
Default is given by \code{\link{l_getOption}("color")}.}

\item{size}{points size of all time series.
Default is given by \code{\link{l_getOption}("size")}.}

\item{lcolor}{line colour of all time series.
Default is given by \code{\link{l_getOption}("color")}.}

\item{linewidth}{line width of all time series (incl. original and decomposed components.
Default is given by \code{\link{l_getOption}("linewidth")}.}

\item{xlabel}{the labels for the x axes.  This is a length four character vector one for each: of the original
time series, the trend component, the seasonality component, and the remainder. If of length 1, the label is repeated; if \code{NULL}, \code{xlabel} is "time".}

\item{ylabel}{the labels for the vertical axes.  This is a length four character vector one for each: of the original
time series, the trend component, the seasonality component, and the remainder. If \code{NULL}, the default,
\code{ylabel} will be \code{c("data", "trend", "seasonality", "remainder")}; if a character vector of length 1, the label is repeated four times.}

\item{title}{an overall title for the entire display. If \code{NULL} (the default), the title will be "Seasonal Trend Analysis".}

\item{tk_title}{provides an alternative window name to Tk's \code{wm title}.  If \code{NULL}, \code{stl} will be used.}

\item{linkingGroup}{name of linking group.
If \code{NULL}, one is created from the data name and class associated with \code{stlOrDecomposedTS}.}

\item{showScales}{a logical as to whether to display the scales on all axes, default is TRUE.}

\item{showGuides}{a logical as to whether to display background guide lines on all plots, default is TRUE.}

\item{showLabels}{a logical as to whether to display axes labels on all plots, default is TRUE.}

\item{...}{keyword value pairs passed off to \code{l_plot()} which constructs each loon scatterplot component.}
}
\value{
A structure of class \code{"l_ts"} containing four loon plots each representing a part of the decomposition
by name: "original", "trend", "seasonal", and "remainder".
}
\description{
\code{l_plot_ts} is a generic function for creating a decomposed time series plot. It
is mainly used in \code{l_plot.decomposed.ts} and \code{l_plot.stl}
}
\seealso{
\code{\link{l_plot.stl}}, \code{\link{l_plot.decomposed.ts}},
\code{\link{stl}}, or \code{\link{decompose}}.

Other time series decomposition plotting functions: 
\code{\link{l_plot.decomposed.ts}()},
\code{\link{l_plot.stl}()}
}
\concept{time series decomposition plotting functions}
