% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loopFuns.R
\name{centredAndScaled}
\alias{centredAndScaled}
\title{Centre and Scale Numeric Data}
\usage{
centredAndScaled(nsloc = NULL)
}
\arguments{
\item{nsloc}{data.frame.  If \code{NULL} or of length zero,
the function returns \code{nsloc} unchanged.}
}
\value{
A numeric vector or matrix of the same dimensions as the input,
with each column centred to mean zero and scaled to unit variance.  If
\code{nsloc} is \code{NULL}, returns \code{NULL}.
}
\description{
\code{centredAndScaled} centres (subtracts the mean) and scales (divides by
the standard deviation) each column of a numeric vector or matrix.
}
\details{
If \code{nsloc} has only one column, the function computes the mean and
standard deviation of the entire vector.  If \code{nsloc} has multiple
columns, each column is centred and scaled independently.
}
\examples{
# Centre and scale a simple vector
centredAndScaled(data.frame(1:10))

# Centre and scale each column of a matrix
mat <- as.data.frame(matrix(stats::rnorm(30), nrow = 10, ncol = 3))
centredAndScaled(mat)

}
