% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust2integers.R
\name{adjust2integers}
\alias{adjust2integers}
\title{Integer-adjusts outputs of the lphom-family functions}
\usage{
adjust2integers(x, ...)
}
\arguments{
\item{x}{An object output of a lphom family algorithm}

\item{...}{Other arguments passed on the method. Not currently used.}
}
\value{
An object of the same class and components as \code{x} with its components properly updated after adjusting the estimated count matrices in \code{x} using integer linear programming
}
\description{
Takes as input an object generated with an algorithm of the lphom-family
(lphom, tslphom, nslphom, tslphom_dual, nslphom_joint, ....) and returns
as output an object of the same class as the input object with all their relevant estimated (local and global) transfer matrices
of counts updated to their closest integer matrices. The rest of main components of the object are also accordingly updated.
}
\details{
The updating of the matrices is performed using integer linear programming after imposing all the row- and column-constraints.
}
\examples{
mt.ns <- nslphom(France2017P[, 1:8] , France2017P[, 9:12], new_and_exit_voters= "raw")
mt.ns <- adjust2integers(mt.ns)
}
\references{
...
}
\author{
Jose M. Pavia, \email{pavia@uv.es}
}
