% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{nbsamplesizeequiv}
\alias{nbsamplesizeequiv}
\title{Sample size for equivalence in negative binomial rate ratio}
\usage{
nbsamplesizeequiv(
  beta = 0.2,
  kMax = 1L,
  informationRates = NA_real_,
  criticalValues = NA_real_,
  alpha = 0.05,
  typeAlphaSpending = "sfOF",
  parameterAlphaSpending = NA_real_,
  userAlphaSpending = NA_real_,
  rateRatioLower = NA_real_,
  rateRatioUpper = NA_real_,
  allocationRatioPlanned = 1,
  accrualTime = 0L,
  accrualIntensity = NA_real_,
  piecewiseSurvivalTime = 0L,
  stratumFraction = 1L,
  kappa1 = NA_real_,
  kappa2 = NA_real_,
  lambda1 = NA_real_,
  lambda2 = NA_real_,
  gamma1 = 0L,
  gamma2 = 0L,
  accrualDuration = NA_real_,
  followupTime = NA_real_,
  fixedFollowup = 0L,
  interval = as.numeric(c(0.001, 240)),
  spendingTime = NA_real_,
  rounding = 1L,
  nullVariance = 0L
)
}
\arguments{
\item{beta}{The type II error.}

\item{kMax}{The maximum number of stages.}

\item{informationRates}{The information rates.
Defaults to \code{(1:kMax) / kMax} if left unspecified.}

\item{criticalValues}{Upper boundaries on the z-test statistic scale
for stopping for efficacy.}

\item{alpha}{The significance level for each of the two one-sided
tests. Defaults to 0.05.}

\item{typeAlphaSpending}{The type of alpha spending. One of the following:
"OF" for O'Brien-Fleming boundaries, "P" for Pocock boundaries,
"WT" for Wang & Tsiatis boundaries, "sfOF" for O'Brien-Fleming type
spending function, "sfP" for Pocock type spending function,
"sfKD" for Kim & DeMets spending function, "sfHSD" for Hwang,
Shi & DeCani spending function, "user" for user defined spending,
and "none" for no early efficacy stopping. Defaults to "sfOF".}

\item{parameterAlphaSpending}{The parameter value for the alpha spending.
Corresponds to Delta for "WT", rho for "sfKD", and gamma for "sfHSD".}

\item{userAlphaSpending}{The user defined alpha spending. Cumulative alpha
spent up to each stage.}

\item{rateRatioLower}{The lower equivalence limit of rate ratio.}

\item{rateRatioUpper}{The upper equivalence limit of rate ratio.}

\item{allocationRatioPlanned}{Allocation ratio for the active treatment
versus control. Defaults to 1 for equal randomization.}

\item{accrualTime}{A vector that specifies the starting time of
piecewise Poisson enrollment time intervals. Must start with 0, e.g.,
\code{c(0, 3)} breaks the time axis into 2 accrual intervals:
[0, 3) and [3, Inf).}

\item{accrualIntensity}{A vector of accrual intensities. One for
each accrual time interval.}

\item{piecewiseSurvivalTime}{A vector that specifies the starting time of
piecewise exponential survival time intervals. Must start with 0, e.g.,
\code{c(0, 6)} breaks the time axis into 2 event intervals:
[0, 6) and [6, Inf).
Defaults to 0 for exponential distribution.}

\item{stratumFraction}{A vector of stratum fractions that sum to 1.
Defaults to 1 for no stratification.}

\item{kappa1}{The dispersion parameter (reciprocal of the shape parameter
of the gamma mixing distribution) for the active treatment group by
stratum.}

\item{kappa2}{The dispersion parameter (reciprocal of the shape parameter
of the gamma mixing distribution) for the control group by stratum.}

\item{lambda1}{The rate parameter of the negative binomial distribution
for the active treatment group by stratum.}

\item{lambda2}{The rate parameter of the negative binomial distribution
for the control group by stratum.}

\item{gamma1}{The hazard rate for exponential dropout, a vector of hazard
rates for piecewise exponential dropout applicable for all strata, or a
vector of hazard rates for dropout in each analysis time interval
by stratum for the active treatment group.}

\item{gamma2}{The hazard rate for exponential dropout, a vector of hazard
rates for piecewise exponential dropout applicable for all strata, or a
vector of hazard rates for dropout in each analysis time interval
by stratum for the control group.}

\item{accrualDuration}{Duration of the enrollment period.}

\item{followupTime}{Follow-up time for the last enrolled subject.}

\item{fixedFollowup}{Whether a fixed follow-up design is used.
Defaults to 0 for variable follow-up.}

\item{interval}{The interval to search for the solution of
accrualDuration, followupDuration, or the proportionality constant
of accrualIntensity. Defaults to \code{c(0.001, 240)}.}

\item{spendingTime}{A vector of length \code{kMax} for the error spending
time at each analysis. Defaults to missing, in which case, it is the
same as \code{informationRates}.}

\item{rounding}{Whether to round up sample size.
Defaults to 1 for sample size rounding.}

\item{nullVariance}{Whether to calculate the variance for log rate ratio
under the null hypothesis.}
}
\value{
An S3 class \code{nbpowerequiv} object
}
\description{
Obtains the sample size for equivalence in negative binomial
rate ratio.
}
\examples{

# Example 1: Variable follow-up design and solve for follow-up time
nbsamplesizeequiv(beta = 0.1, kMax = 2, informationRates = c(0.5, 1),
                  alpha = 0.05, typeAlphaSpending = "sfOF",
                  rateRatioLower = 2/3, rateRatioUpper = 3/2,
                  accrualIntensity = 1956/1.25,
                  stratumFraction = c(0.2, 0.8),
                  kappa1 = c(3, 5),
                  kappa2 = c(2, 3),
                  lambda1 = c(0.125, 0.165),
                  lambda2 = c(0.135, 0.175),
                  gamma1 = -log(1-0.05),
                  gamma2 = -log(1-0.10),
                  accrualDuration = 1.25,
                  followupTime = NA, fixedFollowup = FALSE,
                  nullVariance = 1)

# Example 2: Fixed follow-up design and solve for accrual duration
nbsamplesizeequiv(beta = 0.2, kMax = 2, informationRates = c(0.5, 1),
                  alpha = 0.05, typeAlphaSpending = "sfOF",
                  rateRatioLower = 0.5, rateRatioUpper = 2,
                  accrualIntensity = 220/1.5,
                  kappa1 = 3, kappa2 = 3,
                  lambda1 = 8.4, lambda2 = 8.4,
                  gamma1 = 0, gamma2 = 0,
                  accrualDuration = NA,
                  followupTime = 0.5, fixedFollowup = TRUE)

}
\seealso{
\code{\link{nbpowerequiv}}
}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
