% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/indarr.R
\name{indarr}
\alias{indarr}
\title{Create Array of Indicator Matrices}
\usage{
indarr(x, maxcat, na.add = TRUE)
}
\arguments{
\item{x}{a \code{matrix} of \code{data.frame}}

\item{maxcat}{an integer indicating the maximum of the rating scale (which is assumed to start with 1)}

\item{na.add}{logical indicating whether to add a designated category for missings or not. Defaults to TRUE.}
}
\value{
A list of rating by item indicator matrices.
}
\description{
This function takes a \code{matrix} or \code{data.frame} and the number of rating categories \code{maxcat}
and produces a three-way array of \code{m} by \code{maxcat} indicator matrices, one for each of the \code{n} rows.
The input \code{x} must be a \code{matrix} or \code{data.frame} of dimensions \code{n} by \code{m}
which contains the ratings on a scale of 1 to \code{maxcat} for \code{m} items. Note that missing values
(\code{NA}'s) will not appear in the columns.
}
\examples{
data("lov")
arr <- indarr(lov[1:10, 1:9], maxcat = 9)
str(arr)
}
\author{
Pieter C. Schoonees
}

