% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unlibrary.R
\name{unlibrary}
\alias{unlibrary}
\title{Unload a package}
\usage{
unlibrary(package)
}
\arguments{
\item{package}{A package name, which may be specified with or without quotes.}
}
\value{
Identical to \code{detach}.
}
\description{
A wrapper function to \code{\link{detach}} that removes a package
from the search path, but takes a package name as input similar to \code{\link{library}}.
}
\details{
Unloads a package. This is just a wrapper for the \code{detach}
function. However, the \code{package} argument is just the name of the
package (rather than the longer string that is required by the \code{detach}
function), and -- like the \code{library} function -- can be specified
without quote marks. The \code{unlibrary} function does not unload dependencies,
only the named package.

The name "unlibrary" is a bit of an abuse of both R terminology (in which
one has a library of packages) and the English language, but I think it
helps convey that the goal of the \code{unlibrary} function is to do the
opposite of what the \code{library} function does.
}
\seealso{
\code{\link{library}}, \code{\link{require}}, \code{\link{detach}}
}
